/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven;

import de.taimos.dvalin.interconnect.model.maven.model.GeneratorModel;
import de.taimos.dvalin.interconnect.model.maven.model.ModelTools;
import de.taimos.dvalin.interconnect.model.metamodel.IGeneratorDefinition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.implement.IncludeRelativePath;
import org.apache.velocity.context.Context;

public class GeneratorHelper {
    public static void writeFile(Log log, GeneratorModel<?, ?> model, String targetDir) throws MojoExecutionException {
        if (model.generateClazzWithTemplates() == null || model.generateClazzWithTemplates().size() < 1) {
            return;
        }
        for (Map.Entry<String, String> templateEntry : model.generateClazzWithTemplates().entrySet()) {
            Template template;
            try {
                template = Velocity.getTemplate((String)templateEntry.getValue(), (String)"UTF-8");
            }
            catch (Exception e) {
                log.error((CharSequence)("Failed to retrieve Template " + templateEntry.getValue()), (Throwable)e);
                throw new MojoExecutionException("Failed to retrieve Template " + templateEntry.getValue(), e);
            }
            try {
                File pckDir = new File(targetDir + model.getTargetFolder());
                if (!pckDir.exists()) {
                    pckDir.mkdirs();
                }
                OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(pckDir.getAbsolutePath() + File.separator + templateEntry.getKey() + ".java"), "UTF-8");
                Throwable throwable = null;
                try {
                    log.info((CharSequence)("Creating file " + pckDir.getAbsolutePath() + File.separator + templateEntry.getKey() + ".java"));
                    VelocityContext context = new VelocityContext();
                    context.put("model", model);
                    context.put("tool", (Object)new ModelTools());
                    context.put("clazzName", (Object)templateEntry.getKey());
                    template.merge((Context)context, (Writer)fw);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fw == null) continue;
                    if (throwable != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fw.close();
                }
            }
            catch (IOException e) {
                log.error((CharSequence)("Failed to write the generated file " + templateEntry.getKey()), (Throwable)e);
                throw new MojoExecutionException("Failed to write the generated file " + templateEntry.getKey(), (Exception)e);
            }
        }
    }

    public static Properties getVelocityDefaultProps() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("eventhandler.include.class", IncludeRelativePath.class.getName());
        return props;
    }

    public static <T extends IGeneratorDefinition> T parseXML(Class<T> clazz, Log log, File f) throws MojoExecutionException {
        try {
            JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jcontext.createUnmarshaller();
            unmarshaller.setEventHandler(validationEvent -> false);
            return (T)((IGeneratorDefinition)unmarshaller.unmarshal(f));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read input file " + f.getAbsolutePath(), e);
        }
    }
}

