/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven.model;

import de.taimos.dvalin.interconnect.model.maven.imports.Imports;
import de.taimos.dvalin.interconnect.model.metamodel.IGeneratorDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public abstract class GeneratorModel<T extends IGeneratorDefinition, K extends Imports<T>> {
    public static final String DEFAULT_TARGET_DIR = "/generated-sources/model/";
    protected K imports;
    protected T definition;
    private Log logger;

    public abstract Map<String, String> generateClazzWithTemplates();

    protected abstract void handleChild(Object var1);

    public String getTargetFolder() {
        return DEFAULT_TARGET_DIR + this.definition.getPackageName().replace('.', File.separatorChar);
    }

    public void init(T ivoDefinition, K imports, Log logger) {
        if (ivoDefinition == null || imports == null) {
            throw new RuntimeException("Failed. Generator was not correctly initialized");
        }
        this.logger = logger;
        this.definition = ivoDefinition;
        this.imports = imports;
        ((Imports)this.imports).initDefaults();
        this.prepareChildren();
        this.beforeChildHandling();
        for (Object child : this.definition.getChildren()) {
            this.handleChild(child);
        }
        this.afterChildHandling();
    }

    protected void beforeChildHandling() {
    }

    protected void afterChildHandling() {
    }

    private void prepareChildren() {
        if (this.definition.getChildren() == null) {
            this.definition.setChildren(new ArrayList());
        }
    }

    protected Log getLogger() {
        return this.logger;
    }
}

