/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven;

import de.taimos.dvalin.interconnect.model.maven.GeneratorHelper;
import de.taimos.dvalin.interconnect.model.maven.ModelType;
import de.taimos.dvalin.interconnect.model.maven.model.event.EventModel;
import de.taimos.dvalin.interconnect.model.maven.model.event.InterfaceEventModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.EditIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.FilterIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.IVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.InterfaceIVOModel;
import de.taimos.dvalin.interconnect.model.metamodel.defs.EventDef;
import de.taimos.dvalin.interconnect.model.metamodel.defs.IVODef;
import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.app.Velocity;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generateModel", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateModel
extends AbstractMojo {
    private static final String TARGET_DIR_EVENT = "/generated-sources/model/event/";
    @Component
    private BuildContext buildContext;
    @Parameter(required=true, property="project.build.directory")
    private String outputDirectory;
    @Deprecated
    @Parameter
    private File[] defdirs;
    @Parameter
    private File[] ivoPaths;
    @Parameter
    private File[] eventPaths;
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Velocity.init((Properties)GeneratorHelper.getVelocityDefaultProps());
        this.execute(this.ivoPaths, ModelType.IVO);
        this.execute(this.eventPaths, ModelType.EVENT);
        if (this.defdirs != null && this.defdirs.length > 0) {
            this.getLog().warn((CharSequence)"Please be aware that you are still using a deprecated configuration. This configuration option might be removed in the future. Please use \"ivoPaths\" and \"enventPaths\" instead of \"defdirs\"!");
            this.execute(this.defdirs, ModelType.IVO);
        }
    }

    private void execute(File[] dir, ModelType type) throws MojoExecutionException {
        try {
            if (dir != null && dir.length > 0) {
                for (File f : dir) {
                    this.processDirectory(f, type);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed...", e);
        }
    }

    private void processDirectory(File f, ModelType type) throws MojoExecutionException {
        File[] defFiles;
        this.getLog().info((CharSequence)("Processing Directory: " + f.getAbsolutePath()));
        File[] dirs = f.listFiles(File::isDirectory);
        if (dirs != null) {
            for (File file : dirs) {
                this.processDirectory(file, type);
            }
        }
        if ((defFiles = f.listFiles((dir, name) -> name.endsWith(".xml"))) != null) {
            block9: for (File defFile : defFiles) {
                switch (type) {
                    case IVO: {
                        File path;
                        this.getLog().info((CharSequence)("Generating files for IVO in " + defFile.getAbsolutePath()));
                        try {
                            this.processFileAsIVO(defFile);
                            path = new File(this.getOutputDirectory() + "/generated-sources/model/");
                            this.project.addCompileSourceRoot(path.getAbsolutePath());
                            this.buildContext.refresh(path);
                            continue block9;
                        }
                        catch (MojoExecutionException e) {
                            if (e.getCause().getMessage().contains("event")) {
                                this.getLog().warn((CharSequence)"An event file was found in the ivo directory. Please fix this.");
                                this.processFileAsEvent(defFile);
                                continue block9;
                            }
                            this.getLog().error((CharSequence)("Failed to read input file " + f.getAbsolutePath()), (Throwable)e);
                            throw e;
                        }
                    }
                    case EVENT: {
                        File path;
                        this.getLog().info((CharSequence)("Generating files for Event in " + defFile.getAbsolutePath()));
                        try {
                            this.processFileAsEvent(defFile);
                            path = new File(this.getOutputDirectory() + "/generated-sources/model/");
                            this.project.addCompileSourceRoot(path.getAbsolutePath());
                            this.buildContext.refresh(path);
                            continue block9;
                        }
                        catch (MojoExecutionException e) {
                            if (e.getCause().getMessage().contains("ivo")) {
                                this.getLog().warn((CharSequence)"An ivo file was found in the ivo directory. Please fix this.");
                                this.processFileAsIVO(defFile);
                                continue block9;
                            }
                            this.getLog().error((CharSequence)("Failed to read input file " + f.getAbsolutePath()), (Throwable)e);
                            throw e;
                        }
                    }
                }
            }
        }
    }

    protected void processFileAsIVO(File f) throws MojoExecutionException {
        IVODef ivod = GeneratorHelper.parseXML(IVODef.class, this.getLog(), f);
        GeneratorHelper.writeFile(this.getLog(), new InterfaceIVOModel(ivod, this.getLog()), this.getOutputDirectory());
        GeneratorHelper.writeFile(this.getLog(), new IVOModel(ivod, this.getLog()), this.getOutputDirectory());
        GeneratorHelper.writeFile(this.getLog(), new FilterIVOModel(ivod, this.getLog()), this.getOutputDirectory());
        GeneratorHelper.writeFile(this.getLog(), new EditIVOModel(ivod, this.getLog()), this.getOutputDirectory());
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void processFileAsEvent(File f) throws MojoExecutionException {
        EventDef eventd = GeneratorHelper.parseXML(EventDef.class, this.getLog(), f);
        GeneratorHelper.writeFile(this.getLog(), new InterfaceEventModel(eventd, this.getLog()), this.getOutputDirectory());
        GeneratorHelper.writeFile(this.getLog(), new EventModel(eventd, this.getLog()), this.getOutputDirectory());
    }
}

