/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class GeneratorHelper {
    static void writeFile(Log log, VelocityContext context, String templateName, String pkgName, String clazzName, String outputDirectory, String targetDir) throws MojoExecutionException {
        Template template = null;
        try {
            template = Velocity.getTemplate((String)templateName, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error((CharSequence)("Failed to retrieve Template " + templateName), (Throwable)e);
            throw new MojoExecutionException("Failed to retrieve Template " + templateName, e);
        }
        try {
            File pckDir = new File(outputDirectory + targetDir + pkgName.replace('.', '/'));
            if (!pckDir.exists()) {
                pckDir.mkdirs();
            }
            try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputDirectory + targetDir + pkgName.replace('.', '/') + "/" + clazzName + ".java"), "UTF-8");){
                template.merge((Context)context, (Writer)fw);
            }
        }
        catch (IOException e) {
            log.error((CharSequence)("Failed to write the generated file " + clazzName), (Throwable)e);
            throw new MojoExecutionException("Failed to write the generated file " + clazzName, (Exception)e);
        }
    }

    static Properties getDefaultProps() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return props;
    }

    static <T> T parseXML(Class<T> clazz, Log log, File f) throws MojoExecutionException {
        try {
            JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            return (T)jcontext.createUnmarshaller().unmarshal(f);
        }
        catch (Exception e) {
            log.error((CharSequence)("Failed to read input file " + f.getAbsolutePath()), (Throwable)e);
            throw new MojoExecutionException("Failed to read input file " + f.getAbsolutePath(), e);
        }
    }
}

