/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven;

import de.taimos.dvalin.interconnect.model.maven.FileType;
import de.taimos.dvalin.interconnect.model.maven.GeneratorHelper;
import de.taimos.dvalin.interconnect.model.maven.MetaModelHelper;
import de.taimos.dvalin.interconnect.model.metamodel.IVODef;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generateModel", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateModel
extends AbstractMojo {
    private static final String IVO_TEMPLATE = "ivotemplate.vm";
    private static final String IVO_ID_TEMPLATE = "ivoIdTemplate.vm";
    private static final String IVO_INTERFACE_ID_TEMPLATE = "ivoInterfaceIdTemplate.vm";
    private static final String IVO_OBJECT_TEMPLATE = "ivoObjectTemplate.vm";
    private static final String IVO_INTERFACE_OBJECT_TEMPLATE = "ivoInterfaceObjectTemplate.vm";
    private static final String IVO_INTERFACE_TEMPLATE = "ivointerfacetemplate.vm";
    private static final String TARGET_DIR = "/generated-sources/model/";
    private static final String IVO_INTERFACE_FILTER_TEMPLATE = "ivoInterfaceFilterTemplate.vm";
    private static final String IVO_FILTER_TEMPLATE = "ivoFilterTemplate.vm";
    @Component
    private BuildContext buildContext;
    @Parameter(required=true, property="project.build.directory")
    private String outputDirectory;
    @Parameter(required=true)
    private File[] defdirs;
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            for (File f : this.defdirs) {
                this.processDirectory(f);
            }
            File path = new File(this.outputDirectory + TARGET_DIR);
            this.project.addCompileSourceRoot(path.getAbsolutePath());
            this.buildContext.refresh(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Failed...", e);
        }
    }

    private void processDirectory(File f) throws MojoExecutionException {
        File[] defFiles;
        this.getLog().info((CharSequence)("Processing Directory: " + f.getAbsolutePath()));
        File[] dirs = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (dirs != null) {
            for (File file : dirs) {
                this.processDirectory(file);
            }
        }
        for (File defFile : defFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) {
            this.getLog().info((CharSequence)("Generating files for IVO in " + defFile.getAbsolutePath()));
            this.processFile(defFile);
        }
    }

    private boolean notToBeRemoved(String dateString) {
        Date removalDate;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        try {
            removalDate = format.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse the removal date - should be yyyy/MM/dd, is " + dateString);
        }
        return removalDate.compareTo(Calendar.getInstance().getTime()) > 0;
    }

    private void processFile(File f) throws MojoExecutionException {
        IVODef ivod = GeneratorHelper.parseXML(IVODef.class, this.getLog(), f);
        Velocity.init((Properties)GeneratorHelper.getDefaultProps());
        VelocityContext metacontext = new VelocityContext();
        metacontext.put("ivod", (Object)ivod);
        metacontext.put("mmh", (Object)new MetaModelHelper(ivod));
        GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_TEMPLATE, ivod.getPkgName(), "I" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        if (ivod.getRemovalDate() == null || ivod.getRemovalDate().isEmpty() || this.notToBeRemoved(ivod.getRemovalDate())) {
            if (!Boolean.TRUE.equals(ivod.getInterfaceOnly())) {
                GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_TEMPLATE, ivod.getPkgName(), ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
                this.generateFindById(ivod, metacontext);
                this.generateCreate(ivod, metacontext);
                this.generateDelete(ivod, metacontext);
                this.generateUpdate(ivod, metacontext);
                this.generateFilter(ivod, metacontext);
                this.generateFindByIDAudited(ivod, metacontext);
            }
        } else {
            this.getLog().info((CharSequence)("IVO " + ivod.getName() + "_v" + ivod.getVersion() + " is beyond removal date, only the interface is generated."));
        }
    }

    private void generateFindById(IVODef ivod, VelocityContext metacontext) throws MojoExecutionException {
        if (Boolean.TRUE.equals(ivod.getGenerateFindById())) {
            ((MetaModelHelper)metacontext.get("mmh")).setType(FileType.FINDBY);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_ID_TEMPLATE, ivod.getPkgName() + "/requests", "IFind" + ivod.getName() + "ByIdIVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_ID_TEMPLATE, ivod.getPkgName() + "/requests", "Find" + ivod.getName() + "ByIdIVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        }
    }

    private void generateCreate(IVODef ivod, VelocityContext metacontext) throws MojoExecutionException {
        if (Boolean.TRUE.equals(ivod.getGenerateCreate())) {
            ((MetaModelHelper)metacontext.get("mmh")).setType(FileType.CREATE);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_OBJECT_TEMPLATE, ivod.getPkgName() + "/requests", "ICreate" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_OBJECT_TEMPLATE, ivod.getPkgName() + "/requests", "Create" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        }
    }

    private void generateUpdate(IVODef ivod, VelocityContext metacontext) throws MojoExecutionException {
        if (Boolean.TRUE.equals(ivod.getGenerateUpdate())) {
            ((MetaModelHelper)metacontext.get("mmh")).setType(FileType.UPDATE);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_OBJECT_TEMPLATE, ivod.getPkgName() + "/requests", "IUpdate" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_OBJECT_TEMPLATE, ivod.getPkgName() + "/requests", "Update" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        }
    }

    private void generateDelete(IVODef ivod, VelocityContext metacontext) throws MojoExecutionException {
        if (Boolean.TRUE.equals(ivod.getGenerateDelete())) {
            ((MetaModelHelper)metacontext.get("mmh")).setType(FileType.DELETE);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_ID_TEMPLATE, ivod.getPkgName() + "/requests", "IDelete" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_ID_TEMPLATE, ivod.getPkgName() + "/requests", "Delete" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        }
    }

    private void generateFilter(IVODef ivod, VelocityContext metacontext) throws MojoExecutionException {
        if (Boolean.TRUE.equals(ivod.getGenerateFilter())) {
            ((MetaModelHelper)metacontext.get("mmh")).setType(FileType.FILTER);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_FILTER_TEMPLATE, ivod.getPkgName() + "/requests", "IFind" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_FILTER_TEMPLATE, ivod.getPkgName() + "/requests", "Find" + ivod.getName() + "IVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        }
    }

    private void generateFindByIDAudited(IVODef ivod, VelocityContext metacontext) throws MojoExecutionException {
        if (Boolean.TRUE.equals(ivod.getAuditing()) && Boolean.TRUE.equals(ivod.getGenerateFindById())) {
            ((MetaModelHelper)metacontext.get("mmh")).setType(FileType.AUDITING);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_INTERFACE_ID_TEMPLATE, ivod.getPkgName() + "/requests", "IFind" + ivod.getName() + "ByIdAuditedIVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
            GeneratorHelper.writeFile(this.getLog(), metacontext, IVO_ID_TEMPLATE, ivod.getPkgName() + "/requests", "Find" + ivod.getName() + "ByIdAuditedIVO_v" + ivod.getVersion(), this.outputDirectory, TARGET_DIR);
        }
    }
}

