/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

public class HTTPResponse
implements AutoCloseable {
    private final HttpResponse response;

    public HTTPResponse(HttpResponse response) {
        this.response = response;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getResponseAsString() {
        try {
            return EntityUtils.toString((HttpEntity)this.response.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getResponseAsBytes() {
        try {
            return EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public boolean isStatusOK() {
        int code = this.getStatus();
        return code >= 200 && code <= 299;
    }

    public boolean isStatusRedirect() {
        int code = this.getStatus();
        return code >= 300 && code <= 399;
    }

    public boolean isStatusClientError() {
        int code = this.getStatus();
        return code >= 400 && code <= 499;
    }

    public boolean isStatusServerError() {
        int code = this.getStatus();
        return code >= 500 && code <= 599;
    }

    @Override
    public void close() {
        try {
            this.response.getEntity().getContent().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

