/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

import de.taimos.httputils.HTTPResponse;
import de.taimos.httputils.HTTPResponseCallback;
import de.taimos.httputils.Retryable;
import de.taimos.httputils.WaitStrategy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class HTTPRequest {
    private static final Executor DEFAULT_EXECUTOR = Executors.newCachedThreadPool();
    private static CloseableHttpClient DEFAULT_HTTP_CLIENT = HttpClientBuilder.create().build();
    private final String url;
    private final Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> queryParams = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, String> pathParams = new ConcurrentHashMap<String, String>();
    private volatile Integer timeout;
    private volatile boolean followRedirect = true;
    private volatile String body = "";
    private volatile String userAgent = null;
    private volatile int maxRetries = 0;
    private volatile Retryable retryable = null;
    private volatile WaitStrategy waitStrategy = null;

    HTTPRequest(String url) {
        this.url = url;
    }

    public static void resetHTTPClient() {
        DEFAULT_HTTP_CLIENT = HttpClientBuilder.create().build();
    }

    public HTTPRequest header(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new CopyOnWriteArrayList());
        }
        this.headers.get(name).add(value);
        return this;
    }

    public HTTPRequest queryParam(String name, String value) {
        if (!this.queryParams.containsKey(name)) {
            this.queryParams.put(name, new CopyOnWriteArrayList());
        }
        this.queryParams.get(name).add(value);
        return this;
    }

    public HTTPRequest pathParam(String name, String value) {
        this.pathParams.put(name, value);
        return this;
    }

    public HTTPRequest timeout(int newTimeout) {
        this.timeout = newTimeout;
        return this;
    }

    public HTTPRequest followRedirect(boolean follow) {
        this.followRedirect = follow;
        return this;
    }

    public HTTPRequest retry(int maxRetries, Retryable retryable, WaitStrategy waitStrategy) {
        if (maxRetries <= 0) {
            throw new IllegalArgumentException("maxRetries must be > 0");
        }
        if (retryable == null) {
            throw new IllegalArgumentException("retryable must not be null");
        }
        if (waitStrategy == null) {
            throw new IllegalArgumentException("waitStrategy must not be null");
        }
        this.maxRetries = maxRetries;
        this.retryable = retryable;
        this.waitStrategy = waitStrategy;
        return this;
    }

    public HTTPRequest retry() {
        return this.retry(5, Retryable.standard(), WaitStrategy.exponentialBackoff());
    }

    public HTTPRequest userAgent(String agent) {
        this.userAgent = agent;
        return this;
    }

    public HTTPRequest contentType(String type) {
        return this.header("Content-Type", type);
    }

    public HTTPRequest auth(String authString) {
        return this.header("Authorization", authString);
    }

    public HTTPRequest authBasic(String user, String password) {
        if (user == null || password == null) {
            throw new IllegalArgumentException("Neither user nor password can be null");
        }
        if (user.contains(":")) {
            throw new IllegalArgumentException("Colon not allowed in user according to RFC2617 Sec. 2");
        }
        String credentials = user + ":" + password;
        String auth = Base64.encodeBase64String((byte[])credentials.getBytes());
        return this.auth("Basic " + auth);
    }

    public HTTPRequest authBearer(String accessToken) {
        return this.auth("Bearer " + accessToken);
    }

    public HTTPRequest accept(String type) {
        return this.header("Accept", type);
    }

    public HTTPRequest body(String bodyString) {
        this.body = bodyString;
        return this;
    }

    public HTTPRequest form(Map<String, String> form) {
        StringBuilder formString = new StringBuilder();
        Iterator<Map.Entry<String, String>> parts = form.entrySet().iterator();
        if (parts.hasNext()) {
            Map.Entry<String, String> firstEntry = parts.next();
            formString.append(firstEntry.getKey());
            formString.append("=");
            formString.append(firstEntry.getValue());
            while (parts.hasNext()) {
                Map.Entry<String, String> entry = parts.next();
                formString.append("&");
                formString.append(entry.getKey());
                formString.append("=");
                formString.append(entry.getValue());
            }
        }
        return this.contentType("application/x-www-form-urlencoded").body(formString.toString());
    }

    public HTTPResponse get() {
        return this.execute(Method.GET);
    }

    public HTTPResponse put() {
        return this.execute(Method.PUT);
    }

    public HTTPResponse patch() {
        return this.execute(Method.PATCH);
    }

    public HTTPResponse post() {
        return this.execute(Method.POST);
    }

    public HTTPResponse delete() {
        return this.execute(Method.DELETE);
    }

    public HTTPResponse options() {
        return this.execute(Method.OPTIONS);
    }

    public HTTPResponse head() {
        return this.execute(Method.HEAD);
    }

    public void getAsync(HTTPResponseCallback callback) {
        this.getAsync(DEFAULT_EXECUTOR, callback);
    }

    public void getAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.GET, callback);
    }

    public void putAsync(HTTPResponseCallback callback) {
        this.putAsync(DEFAULT_EXECUTOR, callback);
    }

    public void putAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.PUT, callback);
    }

    public void patchAsync(HTTPResponseCallback callback) {
        this.patchAsync(DEFAULT_EXECUTOR, callback);
    }

    public void patchAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.PATCH, callback);
    }

    public void postAsync(HTTPResponseCallback callback) {
        this.postAsync(DEFAULT_EXECUTOR, callback);
    }

    public void postAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.POST, callback);
    }

    public void deleteAsync(HTTPResponseCallback callback) {
        this.deleteAsync(DEFAULT_EXECUTOR, callback);
    }

    public void deleteAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.DELETE, callback);
    }

    public void optionsAsync(HTTPResponseCallback callback) {
        this.optionsAsync(DEFAULT_EXECUTOR, callback);
    }

    public void optionsAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.OPTIONS, callback);
    }

    public void headAsync(HTTPResponseCallback callback) {
        this.headAsync(DEFAULT_EXECUTOR, callback);
    }

    public void headAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, Method.HEAD, callback);
    }

    private void executeAsync(Executor executor, Method method, HTTPResponseCallback cb) {
        Runnable execute = () -> {
            HTTPResponse res;
            try {
                res = this.execute(method);
            }
            catch (Exception e) {
                cb.fail(e);
                return;
            }
            try {
                cb.response(res);
            }
            finally {
                res.close();
            }
        };
        executor.execute(execute);
    }

    private HTTPResponse execute(Method method) {
        URI uri = this.buildURI();
        for (int attempt = 0; attempt <= this.maxRetries; ++attempt) {
            int wait;
            if (attempt > 0 && (wait = this.waitStrategy.milliseconds(attempt - 1)) > 0) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                HTTPResponse response = this.attempt(method, uri);
                if (this.retryable != null) {
                    int statusCode = response.getStatus();
                    if (this.retryable.retry(Optional.empty(), Optional.of(statusCode))) {
                        response.close();
                        if (attempt < this.maxRetries) continue;
                        throw new RuntimeException("status code " + statusCode);
                    }
                }
                return response;
            }
            catch (IOException e) {
                if (this.retryable != null) {
                    if (attempt < this.maxRetries) continue;
                    throw new RuntimeException("retry exhausted", e);
                }
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                if (this.retryable != null) {
                    if (attempt < this.maxRetries) continue;
                    throw new RuntimeException("retry exhausted", e);
                }
                throw e;
            }
        }
        throw new RuntimeException("retry failed");
    }

    private HTTPResponse attempt(Method method, URI uri) throws IOException {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.timeout != null) {
            requestConfigBuilder.setConnectTimeout(this.timeout.intValue());
            requestConfigBuilder.setConnectionRequestTimeout(this.timeout.intValue());
            requestConfigBuilder.setSocketTimeout(this.timeout.intValue());
        }
        requestConfigBuilder.setRedirectsEnabled(this.followRedirect);
        RequestConfig requestConfig = requestConfigBuilder.build();
        HttpRequestBase request = method.request(uri);
        request.setConfig(requestConfig);
        if (this.userAgent != null && !this.userAgent.isEmpty()) {
            request.setHeader("User-Agent", this.userAgent);
        }
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            List<String> list = entry.getValue();
            for (String string : list) {
                request.addHeader(entry.getKey(), string);
            }
        }
        if (request instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityBase = (HttpEntityEnclosingRequestBase)request;
            entityBase.setEntity((HttpEntity)new StringEntity(this.body, "UTF-8"));
        }
        return new HTTPResponse((HttpResponse)DEFAULT_HTTP_CLIENT.execute((HttpUriRequest)request));
    }

    private URI buildURI() {
        try {
            String u = this.url;
            for (Map.Entry<String, String> pathEntry : this.pathParams.entrySet()) {
                u = u.replace("{" + pathEntry.getKey() + "}", pathEntry.getValue());
            }
            URIBuilder builder = new URIBuilder(u);
            Set<Map.Entry<String, List<String>>> entrySet = this.queryParams.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                List<String> list = entry.getValue();
                for (String string : list) {
                    builder.addParameter(entry.getKey(), string);
                }
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI", e);
        }
    }

    static interface Request {
        public HttpRequestBase request(URI var1);
    }

    public static enum Method implements Request
    {
        GET{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpGet(uri);
            }
        }
        ,
        HEAD{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpHead(uri);
            }
        }
        ,
        POST{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpPost(uri);
            }
        }
        ,
        PUT{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpPut(uri);
            }
        }
        ,
        DELETE{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpDelete(uri);
            }
        }
        ,
        PATCH{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpPatch(uri);
            }
        }
        ,
        OPTIONS{

            @Override
            public HttpRequestBase request(URI uri) {
                return new HttpOptions(uri);
            }
        };

    }
}

