/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.SystemDefaultHttpClient;

public class HTTPRequest {
    private final String url;
    private final HashMap<String, List<String>> headers = new HashMap();
    private final HashMap<String, List<String>> queryParams = new HashMap();
    private final HashMap<String, String> pathParams = new HashMap();
    private String body = "";

    public HTTPRequest(String url) {
        this.url = url;
    }

    public HTTPRequest header(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new ArrayList());
        }
        this.headers.get(name).add(value);
        return this;
    }

    public HTTPRequest queryParam(String name, String value) {
        if (!this.queryParams.containsKey(name)) {
            this.queryParams.put(name, new ArrayList());
        }
        this.queryParams.get(name).add(value);
        return this;
    }

    public HTTPRequest pathParam(String name, String value) {
        this.pathParams.put(name, value);
        return this;
    }

    public HTTPRequest contentType(String type) {
        return this.header("Content-Type", type);
    }

    public HTTPRequest auth(String authString) {
        return this.header("Authorization", authString);
    }

    public HTTPRequest authBasic(String user, String password) {
        String credentials = user + ":" + password;
        String auth = Base64.encodeBase64String((byte[])credentials.getBytes());
        return this.auth("Basic " + auth);
    }

    public HTTPRequest authBearer(String accessToken) {
        return this.auth("Bearer " + accessToken);
    }

    public HTTPRequest accept(String type) {
        return this.header("Accept", type);
    }

    public HTTPRequest body(String bodyString) {
        this.body = bodyString;
        return this;
    }

    public HttpResponse get() {
        return this.execute((HttpUriRequest)new HttpGet(this.buildURI()));
    }

    public HttpResponse put() {
        return this.execute((HttpUriRequest)new HttpPut(this.buildURI()));
    }

    public HttpResponse post() {
        return this.execute((HttpUriRequest)new HttpPost(this.buildURI()));
    }

    public HttpResponse delete() {
        return this.execute((HttpUriRequest)new HttpDelete(this.buildURI()));
    }

    public HttpResponse options() {
        return this.execute((HttpUriRequest)new HttpOptions(this.buildURI()));
    }

    private HttpResponse execute(HttpUriRequest req) {
        try {
            SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient();
            if (req instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityBase = (HttpEntityEnclosingRequestBase)req;
                entityBase.setEntity((HttpEntity)new StringEntity(this.body, "UTF-8"));
            }
            Set<Map.Entry<String, List<String>>> entrySet = this.headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                List<String> list = entry.getValue();
                for (String string : list) {
                    req.addHeader(entry.getKey(), string);
                }
            }
            HttpResponse response = httpclient.execute(req);
            return response;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URI buildURI() {
        try {
            String u = this.url;
            for (Map.Entry<String, String> pathEntry : this.pathParams.entrySet()) {
                u = u.replace("{" + pathEntry.getKey() + "}", pathEntry.getValue());
            }
            URIBuilder builder = new URIBuilder(u);
            Set<Map.Entry<String, List<String>>> entrySet = this.queryParams.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                List<String> list = entry.getValue();
                for (String string : list) {
                    builder.addParameter(entry.getKey(), string);
                }
            }
            URI uri = builder.build();
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI", e);
        }
    }
}

