/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public class HTTPRequest {
    private final String url;
    private final HashMap<String, String> headers = new HashMap();
    private final HashMap<String, List<String>> queryParams = new HashMap();
    private String body;

    public HTTPRequest(String url) {
        this.url = url;
    }

    public HTTPRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HTTPRequest queryParam(String name, String value) {
        try {
            String encoded = URLEncoder.encode(value, "UTF-8");
            if (!this.queryParams.containsKey(name)) {
                this.queryParams.put(name, new ArrayList());
            }
            this.queryParams.get(name).add(encoded);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public HTTPRequest body(String body) {
        this.body = body;
        return this;
    }

    public HttpResponse get() {
        return this.execute((HttpUriRequest)new HttpGet(this.buildURI()));
    }

    public HttpResponse put() {
        return this.execute((HttpUriRequest)new HttpPut(this.buildURI()));
    }

    public HttpResponse post() {
        return this.execute((HttpUriRequest)new HttpPost(this.buildURI()));
    }

    private HttpResponse execute(HttpUriRequest req) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            if (req instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityBase = (HttpEntityEnclosingRequestBase)req;
                entityBase.setEntity((HttpEntity)new StringEntity(this.body, "UTF-8"));
            }
            HttpResponse response = httpclient.execute(req);
            return response;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new RuntimeException();
    }

    private URI buildURI() {
        try {
            URIBuilder builder = new URIBuilder(this.url);
            Set<Map.Entry<String, List<String>>> entrySet = this.queryParams.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                List<String> list = entry.getValue();
                for (String string : list) {
                    builder.addParameter(entry.getKey(), string);
                }
            }
            URI uri = builder.build();
            return uri;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid URI");
        }
    }
}

