/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.backend.GPSdEndpoint;
import de.taimos.gpsd4java.backend.WaitableBoolean;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(SocketThread.class);
    private final BufferedReader reader;
    private final GPSdEndpoint endpoint;
    private final AbstractResultParser resultParser;
    private final WaitableBoolean running = new WaitableBoolean(true);

    public SocketThread(BufferedReader reader, GPSdEndpoint endpoint, AbstractResultParser resultParser, boolean daemon) {
        if (resultParser == null) {
            throw new IllegalArgumentException("resultParser can not be null!");
        }
        this.reader = reader;
        this.endpoint = endpoint;
        this.resultParser = resultParser;
        this.setDaemon(daemon);
        this.setName("GPS Socket Thread");
    }

    public SocketThread(BufferedReader reader, GPSdEndpoint endpoint, AbstractResultParser resultParser) {
        this(reader, endpoint, resultParser, true);
    }

    @Override
    public void run() {
        if (this.reader != null) {
            while (this.running.get()) {
                try {
                    String s = this.reader.readLine();
                    if (s == null) break;
                    if (s.isEmpty()) continue;
                    this.endpoint.handle(this.resultParser.parse(s));
                }
                catch (SocketException e) {
                    break;
                }
                catch (Exception e) {
                    LOG.warn("Problem encountered while reading/parsing/handling line", (Throwable)e);
                }
            }
        }
        if (this.running.get() && !Thread.interrupted()) {
            LOG.warn("Problem encountered while reading/parsing/handling line, attempting restart");
            this.retry();
        }
    }

    protected void retry() {
        if (this.reader != null) {
            LOG.debug("Disconnected from GPS socket, retrying connection");
        } else {
            LOG.debug("Connecting to GPSD socket");
        }
        while (this.running.get()) {
            try {
                this.running.waitFor(this.endpoint.getRetryInterval());
                this.endpoint.handleDisconnected();
                LOG.debug("Connected to GPS socket");
                this.running.set(false);
            }
            catch (InterruptedException ix) {
                break;
            }
            catch (IOException e) {
                LOG.debug("Still disconnected from GPS socket, retrying connection again");
            }
        }
    }

    public void halt() {
        this.running.set(false);
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

