/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.types.ATTObject;
import de.taimos.gpsd4java.types.DeviceObject;
import de.taimos.gpsd4java.types.DevicesObject;
import de.taimos.gpsd4java.types.ENMEAMode;
import de.taimos.gpsd4java.types.EParity;
import de.taimos.gpsd4java.types.GSTObject;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import de.taimos.gpsd4java.types.PollObject;
import de.taimos.gpsd4java.types.SATObject;
import de.taimos.gpsd4java.types.SKYObject;
import de.taimos.gpsd4java.types.TPVObject;
import de.taimos.gpsd4java.types.VersionObject;
import de.taimos.gpsd4java.types.WatchObject;
import de.taimos.gpsd4java.types.subframes.ALMANACObject;
import de.taimos.gpsd4java.types.subframes.EPHEM1Object;
import de.taimos.gpsd4java.types.subframes.EPHEM2Object;
import de.taimos.gpsd4java.types.subframes.EPHEM3Object;
import de.taimos.gpsd4java.types.subframes.ERDObject;
import de.taimos.gpsd4java.types.subframes.HEALTH2Object;
import de.taimos.gpsd4java.types.subframes.HEALTHObject;
import de.taimos.gpsd4java.types.subframes.IONOObject;
import de.taimos.gpsd4java.types.subframes.SUBFRAMEObject;
import org.json.JSONObject;

public class LegacyResultParser
extends AbstractResultParser {
    @Override
    public IGPSObject parse(JSONObject json) throws ParseException {
        IGPSObject gps = null;
        String clazz = json.optString("class");
        if ("TPV".equals(clazz)) {
            gps = this.parseTPV(json);
        } else if ("SKY".equals(clazz)) {
            gps = this.parseSKY(json);
        } else if ("GST".equals(clazz)) {
            gps = this.parseGST(json);
        } else if ("ATT".equals(clazz)) {
            gps = this.parseATT(json);
        } else if ("SUBFRAME".equals(clazz)) {
            gps = this.parseSUBFRAME(json);
        } else if ("VERSION".equals(clazz)) {
            gps = this.parseVERSION(json);
        } else if ("DEVICES".equals(clazz)) {
            gps = this.parseDEVICES(json);
        } else if ("DEVICE".equals(clazz)) {
            gps = this.parseDEVICE(json);
        } else if ("WATCH".equals(clazz)) {
            gps = this.parseWATCH(json);
        } else if ("POLL".equals(clazz)) {
            gps = this.parsePOLL(json);
        } else if (json.has("PRN")) {
            gps = this.parsePRN(json);
        } else if (json.has("deltai")) {
            gps = this.parseALMANAC(json);
        } else if (json.has("IODC")) {
            gps = this.parseEPHEM1(json);
        } else if (json.has("Crs")) {
            gps = this.parseEPHEM2(json);
        } else if (json.has("IDOT")) {
            gps = this.parseEPHEM3(json);
        } else if (json.has("ERD30")) {
            gps = this.parseERD(json);
        } else if (json.has("SVH32")) {
            gps = this.parseHEALTH(json);
        } else if (json.has("WNa")) {
            gps = this.parseHEALTH2(json);
        } else if (json.has("WNlsf")) {
            gps = this.parseIONO(json);
        } else {
            throw new ParseException("Invalid object class: " + clazz);
        }
        return gps;
    }

    private IGPSObject parseIONO(JSONObject json) {
        IONOObject iono = new IONOObject();
        iono.setAlpha0(json.optDouble("a0", Double.NaN));
        iono.setAlpha1(json.optDouble("a1", Double.NaN));
        iono.setAlpha2(json.optDouble("a2", Double.NaN));
        iono.setAlpha3(json.optDouble("a3", Double.NaN));
        iono.setBeta0(json.optDouble("b0", Double.NaN));
        iono.setBeta1(json.optDouble("b1", Double.NaN));
        iono.setBeta2(json.optDouble("b2", Double.NaN));
        iono.setBeta3(json.optDouble("b3", Double.NaN));
        iono.setA0(json.optDouble("A0", Double.NaN));
        iono.setA1(json.optDouble("A1", Double.NaN));
        iono.setTot(json.optDouble("tot", Double.NaN));
        iono.setWNt(json.optInt("WNt"));
        iono.setLeap(json.optInt("ls"));
        iono.setWNlsf(json.optInt("WNlsf"));
        iono.setDN(json.optInt("DN"));
        iono.setLsf(json.optInt("lsf"));
        IONOObject gps = iono;
        return gps;
    }

    private IGPSObject parseHEALTH2(JSONObject json) {
        HEALTH2Object health2 = new HEALTH2Object();
        health2.setToa(json.optInt("toa"));
        health2.setWNa(json.optInt("WNa"));
        for (int index = 1; index <= 24; ++index) {
            health2.setSVbyIndex(index - 1, json.optInt("SV" + index));
        }
        HEALTH2Object gps = health2;
        return gps;
    }

    private IGPSObject parseHEALTH(JSONObject json) {
        int index;
        HEALTHObject health = new HEALTHObject();
        health.setData_id(json.optInt("data_id"));
        for (index = 1; index <= 32; ++index) {
            health.setSVbyIndex(index - 1, json.optInt("SV" + index));
        }
        for (index = 0; index <= 7; ++index) {
            health.setSVHbyIndex(index, json.optInt("SVH" + (index + 25)));
        }
        HEALTHObject gps = health;
        return gps;
    }

    private IGPSObject parseERD(JSONObject json) {
        ERDObject erd = new ERDObject();
        erd.setAi(json.optInt("ai"));
        for (int index = 1; index <= 30; ++index) {
            erd.setERDbyIndex(index - 1, json.optInt("ERD" + index));
        }
        ERDObject gps = erd;
        return gps;
    }

    private IGPSObject parseEPHEM3(JSONObject json) {
        EPHEM3Object emphem3 = new EPHEM3Object();
        emphem3.setIODE(json.optInt("IODE"));
        emphem3.setIDOT(json.optDouble("IDOT", Double.NaN));
        emphem3.setCic(json.optDouble("Cic", Double.NaN));
        emphem3.setOmega0(json.optDouble("Omega0", Double.NaN));
        emphem3.setCis(json.optDouble("Cis", Double.NaN));
        emphem3.setI0(json.optDouble("i0", Double.NaN));
        emphem3.setCrc(json.optDouble("Crc", Double.NaN));
        emphem3.setOmega(json.optDouble("omega", Double.NaN));
        emphem3.setOmegad(json.optDouble("Omegad", Double.NaN));
        EPHEM3Object gps = emphem3;
        return gps;
    }

    private IGPSObject parseEPHEM2(JSONObject json) {
        EPHEM2Object emphem2 = new EPHEM2Object();
        emphem2.setIODE(json.optInt("IODE"));
        emphem2.setCrs(json.optDouble("Crs", Double.NaN));
        emphem2.setDeltan(json.optDouble("deltan", Double.NaN));
        emphem2.setM0(json.optDouble("M0", Double.NaN));
        emphem2.setCuc(json.optDouble("Cuc", Double.NaN));
        emphem2.setE(json.optDouble("e", Double.NaN));
        emphem2.setCus(json.optDouble("Cus", Double.NaN));
        emphem2.setSqrtA(json.optInt("sqrtA"));
        emphem2.setToe(json.optInt("toe"));
        emphem2.setFIT(json.optInt("FIT"));
        emphem2.setAODO(json.optInt("AODO"));
        EPHEM2Object gps = emphem2;
        return gps;
    }

    private IGPSObject parseEPHEM1(JSONObject json) {
        EPHEM1Object emphem1 = new EPHEM1Object();
        emphem1.setWN(json.optInt("WN"));
        emphem1.setIODC(json.optInt("IODC"));
        emphem1.setL2(json.optInt("L2"));
        emphem1.setUra(json.optDouble("ura", Double.NaN));
        emphem1.setHlth(json.optDouble("hlth", Double.NaN));
        emphem1.setL2P(json.optInt("L2P"));
        emphem1.setTgd(json.optDouble("Tgd", Double.NaN));
        emphem1.setToc(json.optInt("toc"));
        emphem1.setAf2(json.optDouble("af2", Double.NaN));
        emphem1.setAf1(json.optDouble("af1", Double.NaN));
        emphem1.setAf0(json.optDouble("af0", Double.NaN));
        EPHEM1Object gps = emphem1;
        return gps;
    }

    private IGPSObject parseALMANAC(JSONObject json) {
        ALMANACObject almanac = new ALMANACObject();
        almanac.setID(json.optInt("ID"));
        almanac.setHealth(json.optInt("Health"));
        almanac.setE(json.optDouble("e", Double.NaN));
        almanac.setToa(json.optInt("toa"));
        almanac.setDeltai(json.optDouble("deltai", Double.NaN));
        almanac.setOmegad(json.optDouble("Omegad", Double.NaN));
        almanac.setSqrtA(json.optDouble("sqrtA", Double.NaN));
        almanac.setOmega0(json.optDouble("Omega0", Double.NaN));
        almanac.setOmega(json.optDouble("omega", Double.NaN));
        almanac.setM0(json.optDouble("M0", Double.NaN));
        almanac.setAf0(json.optDouble("af0", Double.NaN));
        almanac.setAf1(json.optDouble("af1", Double.NaN));
        ALMANACObject gps = almanac;
        return gps;
    }

    private IGPSObject parsePRN(JSONObject json) {
        SATObject sat = new SATObject();
        sat.setPRN(json.optInt("PRN", -1));
        sat.setAzimuth(json.optInt("az", -1));
        sat.setElevation(json.optInt("el", -1));
        sat.setSignalStrength(json.optInt("ss", -1));
        sat.setUsed(json.optBoolean("used", false));
        SATObject gps = sat;
        return gps;
    }

    private IGPSObject parsePOLL(JSONObject json) throws ParseException {
        PollObject poll = new PollObject();
        poll.setTimestamp(this.parseTimestamp(json, "time"));
        poll.setActive(json.optInt("active", 0));
        poll.setFixes(this.parseObjectArray(json.optJSONArray("fixes"), TPVObject.class));
        poll.setSkyviews(this.parseObjectArray(json.optJSONArray("skyviews"), SKYObject.class));
        PollObject gps = poll;
        return gps;
    }

    private IGPSObject parseWATCH(JSONObject json) {
        WatchObject watch = new WatchObject();
        watch.setEnable(json.optBoolean("enable", true));
        watch.setDump(json.optBoolean("json", false));
        WatchObject gps = watch;
        return gps;
    }

    private IGPSObject parseDEVICE(JSONObject json) {
        DeviceObject dev = new DeviceObject();
        dev.setPath(json.optString("path", null));
        dev.setActivated(this.parseTimestamp(json, "activated"));
        dev.setDriver(json.optString("driver", null));
        dev.setBps(json.optInt("bps", 0));
        dev.setParity(EParity.fromString(json.optString("parity")));
        dev.setStopbit(json.optInt("stopbit"));
        dev.setNativeMode(json.optInt("native", 0) == 1);
        dev.setCycle(json.optInt("cycle"));
        dev.setMincycle(json.optInt("mincycle"));
        DeviceObject gps = dev;
        return gps;
    }

    private IGPSObject parseDEVICES(JSONObject json) throws ParseException {
        DevicesObject devs = new DevicesObject();
        devs.setDevices(this.parseObjectArray(json.optJSONArray("devices"), DeviceObject.class));
        DevicesObject gps = devs;
        return gps;
    }

    private IGPSObject parseVERSION(JSONObject json) {
        VersionObject ver = new VersionObject();
        ver.setRelease(json.optString("release", null));
        ver.setRev(json.optString("rev", null));
        ver.setProtocolMajor(json.optDouble("proto_major", 0.0));
        ver.setProtocolMinor(json.optDouble("proto_minor", 0.0));
        VersionObject gps = ver;
        return gps;
    }

    private IGPSObject parseSUBFRAME(JSONObject json) throws ParseException {
        SUBFRAMEObject subframe = new SUBFRAMEObject();
        subframe.setDevice(json.optString("device", null));
        subframe.setMSBs(json.optInt("TOW17"));
        subframe.setSatelliteNumber(json.optInt("tSV"));
        subframe.setSubframeNumber(json.optInt("frame"));
        subframe.setScaled(json.optBoolean("scaled", false));
        subframe.setPageid(json.optInt("pageid"));
        if (json.has("system_message")) {
            subframe.setSystemMessage(json.optString("system_message"));
        } else if (json.has("ALMANAC")) {
            subframe.setAlmanac((ALMANACObject)this.parse(json.optJSONObject("ALMANAC")));
        } else if (json.has("EPHEM1")) {
            subframe.setEphem1((EPHEM1Object)this.parse(json.optJSONObject("EPHEM1")));
        } else if (json.has("EPHEM2")) {
            subframe.setEphem2((EPHEM2Object)this.parse(json.optJSONObject("EPHEM2")));
        } else if (json.has("EPHEM3")) {
            subframe.setEphem3((EPHEM3Object)this.parse(json.optJSONObject("EPHEM3")));
        } else if (json.has("ERD")) {
            subframe.setErd((ERDObject)this.parse(json.optJSONObject("ERD")));
        } else if (json.has("HEALTH")) {
            subframe.setHealth((HEALTHObject)this.parse(json.optJSONObject("HEALTH")));
        } else if (json.has("HEALTH2")) {
            subframe.setHealth2((HEALTH2Object)this.parse(json.optJSONObject("HEALTH2")));
        } else if (json.has("IONO")) {
            subframe.setIono((IONOObject)this.parse(json.optJSONObject("IONO")));
        } else {
            AbstractResultParser.LOG.error("Unknown subframe: {}", (Object)json.toString());
        }
        SUBFRAMEObject gps = subframe;
        return gps;
    }

    private IGPSObject parseATT(JSONObject json) {
        ATTObject att = new ATTObject();
        att.setTag(json.optString("tag", null));
        att.setDevice(json.optString("device", null));
        att.setTimestamp(this.parseTimestamp(json, "time"));
        att.setHeading(json.optDouble("heading", Double.NaN));
        att.setPitch(json.optDouble("pitch", Double.NaN));
        att.setYaw(json.optDouble("yaw", Double.NaN));
        att.setRoll(json.optDouble("roll", Double.NaN));
        att.setDip(json.optDouble("dip", Double.NaN));
        att.setMag_len(json.optDouble("mag_len", Double.NaN));
        att.setMag_x(json.optDouble("mag_x", Double.NaN));
        att.setMag_y(json.optDouble("mag_y", Double.NaN));
        att.setMag_z(json.optDouble("mag_z", Double.NaN));
        att.setAcc_len(json.optDouble("acc_len", Double.NaN));
        att.setAcc_x(json.optDouble("acc_x", Double.NaN));
        att.setAcc_y(json.optDouble("acc_y", Double.NaN));
        att.setAcc_z(json.optDouble("acc_z", Double.NaN));
        att.setGyro_x(json.optDouble("gyro_x", Double.NaN));
        att.setGyro_y(json.optDouble("gyro_y", Double.NaN));
        att.setDepth(json.optDouble("depth", Double.NaN));
        att.setTemperature(json.optDouble("temperature", Double.NaN));
        att.setMagState(json.optString("mag_st", null));
        att.setRollState(json.optString("roll_st", null));
        att.setPitchState(json.optString("pitch_st", null));
        att.setYawState(json.optString("yaw_st", null));
        ATTObject gps = att;
        return gps;
    }

    private IGPSObject parseGST(JSONObject json) {
        GSTObject gst = new GSTObject();
        gst.setTag(json.optString("tag", null));
        gst.setDevice(json.optString("device", null));
        gst.setTimestamp(this.parseTimestamp(json, "time"));
        gst.setRms(json.optDouble("rms", Double.NaN));
        gst.setMajor(json.optDouble("major", Double.NaN));
        gst.setMinor(json.optDouble("minor", Double.NaN));
        gst.setOrient(json.optDouble("orient", Double.NaN));
        gst.setLat(json.optDouble("lat", Double.NaN));
        gst.setLon(json.optDouble("lon", Double.NaN));
        gst.setAlt(json.optDouble("alt", Double.NaN));
        GSTObject gps = gst;
        return gps;
    }

    private IGPSObject parseSKY(JSONObject json) throws ParseException {
        SKYObject sky = new SKYObject();
        sky.setTag(json.optString("tag", null));
        sky.setDevice(json.optString("device", null));
        sky.setTimestamp(this.parseTimestamp(json, "time"));
        sky.setLongitudeDOP(json.optDouble("xdop", Double.NaN));
        sky.setLatitudeDOP(json.optDouble("ydop", Double.NaN));
        sky.setAltitudeDOP(json.optDouble("vdop", Double.NaN));
        sky.setTimestampDOP(json.optDouble("tdop", Double.NaN));
        sky.setHorizontalDOP(json.optDouble("hdop", Double.NaN));
        sky.setSphericalDOP(json.optDouble("pdop", Double.NaN));
        sky.setHypersphericalDOP(json.optDouble("gdop", Double.NaN));
        sky.setSatellites(this.parseObjectArray(json.optJSONArray("satellites"), SATObject.class));
        SKYObject gps = sky;
        return gps;
    }

    private IGPSObject parseTPV(JSONObject json) {
        TPVObject tpv = new TPVObject();
        tpv.setTag(json.optString("tag", null));
        tpv.setDevice(json.optString("device", null));
        tpv.setTimestamp(this.parseTimestamp(json, "time"));
        tpv.setTimestampError(json.optDouble("ept", Double.NaN));
        tpv.setLatitude(json.optDouble("lat", Double.NaN));
        tpv.setLongitude(json.optDouble("lon", Double.NaN));
        tpv.setAltitude(json.optDouble("alt", Double.NaN));
        tpv.setLongitudeError(json.optDouble("epx", Double.NaN));
        tpv.setLatitudeError(json.optDouble("epy", Double.NaN));
        tpv.setAltitudeError(json.optDouble("epv", Double.NaN));
        tpv.setCourse(json.optDouble("track", Double.NaN));
        tpv.setSpeed(json.optDouble("speed", Double.NaN));
        tpv.setClimbRate(json.optDouble("climb", Double.NaN));
        tpv.setCourseError(json.optDouble("epd", Double.NaN));
        tpv.setSpeedError(json.optDouble("eps", Double.NaN));
        tpv.setClimbRateError(json.optDouble("epc", Double.NaN));
        tpv.setMode(ENMEAMode.fromInt(json.optInt("mode", 0)));
        TPVObject gps = tpv;
        return gps;
    }
}

