/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.backend.ResultParser;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultParser {
    protected static final Logger LOG = LoggerFactory.getLogger(ResultParser.class);
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public AbstractResultParser() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public IGPSObject parse(String line) throws ParseException {
        try {
            JSONObject json = new JSONObject(line);
            return this.parse(json);
        }
        catch (JSONException e) {
            throw new ParseException("Parsing failed", e);
        }
    }

    public abstract IGPSObject parse(JSONObject var1) throws ParseException;

    protected <T extends IGPSObject> List<T> parseObjectArray(JSONArray array, Class<T> type) throws ParseException {
        try {
            if (array == null) {
                return new ArrayList(10);
            }
            ArrayList<IGPSObject> objects = new ArrayList<IGPSObject>(10);
            for (int i = 0; i < array.length(); ++i) {
                objects.add(this.parse(array.getJSONObject(i)));
            }
            return objects;
        }
        catch (JSONException e) {
            throw new ParseException("Parsing failed", e);
        }
    }

    protected double parseTimestamp(JSONObject json, String fieldName) {
        try {
            String text = json.optString(fieldName, null);
            LOG.debug(fieldName + ": {}", (Object)text);
            if (text != null) {
                Date date = this.dateFormat.parse(text);
                if (LOG.isDebugEnabled()) {
                    String ds = DateFormat.getDateTimeInstance(0, 0).format(date);
                    LOG.debug("Date: {}", (Object)ds);
                }
                return (double)date.getTime() / 1000.0;
            }
        }
        catch (Exception ex) {
            LOG.info("Failed to parse time", (Throwable)ex);
        }
        return Double.NaN;
    }
}

