/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.types.subframes;

import de.taimos.gpsd4java.types.IGPSObject;

public class EPHEM1Object
implements IGPSObject {
    private int WN = -1;
    private int IODC = -1;
    private int L2 = -1;
    private double ura = Double.NaN;
    private double hlth = Double.NaN;
    private int L2P = -1;
    private double Tgd = Double.NaN;
    private int toc = -1;
    private double af2 = Double.NaN;
    private double af1 = Double.NaN;
    private double af0 = Double.NaN;

    public int getWN() {
        return this.WN;
    }

    public void setWN(int wN) {
        this.WN = wN;
    }

    public int getIODC() {
        return this.IODC;
    }

    public void setIODC(int iODC) {
        this.IODC = iODC;
    }

    public int getL2() {
        return this.L2;
    }

    public void setL2(int l2) {
        this.L2 = l2;
    }

    public double getUra() {
        return this.ura;
    }

    public void setUra(double ura) {
        this.ura = ura;
    }

    public double getHlth() {
        return this.hlth;
    }

    public void setHlth(double hlth) {
        this.hlth = hlth;
    }

    public int getL2P() {
        return this.L2P;
    }

    public void setL2P(int l2p) {
        this.L2P = l2p;
    }

    public double getTgd() {
        return this.Tgd;
    }

    public void setTgd(double tgd) {
        this.Tgd = tgd;
    }

    public int getToc() {
        return this.toc;
    }

    public void setToc(int toc) {
        this.toc = toc;
    }

    public double getAf2() {
        return this.af2;
    }

    public void setAf2(double af2) {
        this.af2 = af2;
    }

    public double getAf1() {
        return this.af1;
    }

    public void setAf1(double af1) {
        this.af1 = af1;
    }

    public double getAf0() {
        return this.af0;
    }

    public void setAf0(double af0) {
        this.af0 = af0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EPHEM1Object that = (EPHEM1Object)o;
        if (this.IODC != that.IODC) {
            return false;
        }
        if (this.L2 != that.L2) {
            return false;
        }
        if (this.L2P != that.L2P) {
            return false;
        }
        if (Double.compare(that.Tgd, this.Tgd) != 0) {
            return false;
        }
        if (this.WN != that.WN) {
            return false;
        }
        if (Double.compare(that.af0, this.af0) != 0) {
            return false;
        }
        if (Double.compare(that.af1, this.af1) != 0) {
            return false;
        }
        if (Double.compare(that.af2, this.af2) != 0) {
            return false;
        }
        if (Double.compare(that.hlth, this.hlth) != 0) {
            return false;
        }
        if (this.toc != that.toc) {
            return false;
        }
        return Double.compare(that.ura, this.ura) == 0;
    }

    public int hashCode() {
        int result = this.WN;
        result = 31 * result + this.IODC;
        result = 31 * result + this.L2;
        long temp = this.ura != 0.0 ? Double.doubleToLongBits(this.ura) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.hlth != 0.0 ? Double.doubleToLongBits(this.hlth) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.L2P;
        temp = this.Tgd != 0.0 ? Double.doubleToLongBits(this.Tgd) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.toc;
        temp = this.af2 != 0.0 ? Double.doubleToLongBits(this.af2) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.af1 != 0.0 ? Double.doubleToLongBits(this.af1) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.af0 != 0.0 ? Double.doubleToLongBits(this.af0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EPHEM1Object{WN=");
        sb.append(this.WN);
        sb.append(", IODC=");
        sb.append(this.IODC);
        sb.append(", ura=");
        sb.append(this.ura);
        sb.append(", L2=");
        sb.append(this.L2);
        sb.append(", hlth=");
        sb.append(this.hlth);
        sb.append(", L2P=");
        sb.append(this.L2P);
        sb.append(", Tgd=");
        sb.append(this.Tgd);
        sb.append(", toc=");
        sb.append(this.toc);
        sb.append(", af2=");
        sb.append(this.af2);
        sb.append(", af0=");
        sb.append(this.af0);
        sb.append(", af1=");
        sb.append(this.af1);
        sb.append("}");
        return sb.toString();
    }
}

