/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractResultParser {
    public IGPSObject parse(String line) throws ParseException {
        try {
            JSONObject json = new JSONObject(line);
            return this.parse(json);
        }
        catch (JSONException e) {
            throw new ParseException("Parsing failed", e);
        }
    }

    public abstract IGPSObject parse(JSONObject var1) throws ParseException;

    protected <T extends IGPSObject> List<T> parseObjectArray(JSONArray array, Class<T> componentType) throws ParseException {
        try {
            if (array == null) {
                return new ArrayList(10);
            }
            ArrayList<IGPSObject> objects = new ArrayList<IGPSObject>(10);
            for (int i = 0; i < array.length(); ++i) {
                objects.add(this.parse(array.getJSONObject(i)));
            }
            return objects;
        }
        catch (JSONException e) {
            throw new ParseException("Parsing failed", e);
        }
    }
}

