/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.types;

import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.SATObject;
import java.util.List;

public class SKYObject
implements IGPSObject {
    private String tag = null;
    private String device = null;
    private double timestamp = Double.NaN;
    private double longitudeDOP = Double.NaN;
    private double latitudeDOP = Double.NaN;
    private double altitudeDOP = Double.NaN;
    private double timestampDOP = Double.NaN;
    private double horizontalDOP = Double.NaN;
    private double sphericalDOP = Double.NaN;
    private double hypersphericalDOP = Double.NaN;
    private List<SATObject> satellites;

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(double timestamp) {
        this.timestamp = timestamp;
    }

    public double getLongitudeDOP() {
        return this.longitudeDOP;
    }

    public void setLongitudeDOP(double longitudeDOP) {
        this.longitudeDOP = longitudeDOP;
    }

    public double getLatitudeDOP() {
        return this.latitudeDOP;
    }

    public void setLatitudeDOP(double latitudeDOP) {
        this.latitudeDOP = latitudeDOP;
    }

    public double getAltitudeDOP() {
        return this.altitudeDOP;
    }

    public void setAltitudeDOP(double altitudeDOP) {
        this.altitudeDOP = altitudeDOP;
    }

    public double getTimestampDOP() {
        return this.timestampDOP;
    }

    public void setTimestampDOP(double timestampDOP) {
        this.timestampDOP = timestampDOP;
    }

    public double getHorizontalDOP() {
        return this.horizontalDOP;
    }

    public void setHorizontalDOP(double horizontalDOP) {
        this.horizontalDOP = horizontalDOP;
    }

    public double getSphericalDOP() {
        return this.sphericalDOP;
    }

    public void setSphericalDOP(double sphericalDOP) {
        this.sphericalDOP = sphericalDOP;
    }

    public double getHypersphericalDOP() {
        return this.hypersphericalDOP;
    }

    public void setHypersphericalDOP(double hypersphericalDOP) {
        this.hypersphericalDOP = hypersphericalDOP;
    }

    public List<SATObject> getSatellites() {
        return this.satellites;
    }

    public void setSatellites(List<SATObject> satellites) {
        this.satellites = satellites;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.altitudeDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.device == null ? 0 : this.device.hashCode());
        temp = Double.doubleToLongBits(this.horizontalDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.hypersphericalDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.latitudeDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitudeDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sphericalDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        temp = Double.doubleToLongBits(this.timestamp);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.timestampDOP);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SKYObject other = (SKYObject)obj;
        if (Double.doubleToLongBits(this.altitudeDOP) != Double.doubleToLongBits(other.altitudeDOP)) {
            return false;
        }
        if (this.device == null ? other.device != null : !this.device.equals(other.device)) {
            return false;
        }
        if (Double.doubleToLongBits(this.horizontalDOP) != Double.doubleToLongBits(other.horizontalDOP)) {
            return false;
        }
        if (Double.doubleToLongBits(this.hypersphericalDOP) != Double.doubleToLongBits(other.hypersphericalDOP)) {
            return false;
        }
        if (Double.doubleToLongBits(this.latitudeDOP) != Double.doubleToLongBits(other.latitudeDOP)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitudeDOP) != Double.doubleToLongBits(other.longitudeDOP)) {
            return false;
        }
        if (Double.doubleToLongBits(this.sphericalDOP) != Double.doubleToLongBits(other.sphericalDOP)) {
            return false;
        }
        if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
            return false;
        }
        if (Double.doubleToLongBits(this.timestamp) != Double.doubleToLongBits(other.timestamp)) {
            return false;
        }
        if (Double.doubleToLongBits(this.timestampDOP) != Double.doubleToLongBits(other.timestampDOP)) {
            return false;
        }
        if (this.satellites.size() != other.satellites.size()) {
            return false;
        }
        try {
            for (int i = 0; i < this.satellites.size(); ++i) {
                if (this.satellites.get(i).equals(other.satellites.get(i))) continue;
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SKYObject{time=");
        sb.append(this.timestamp);
        sb.append(", xdop=");
        sb.append(this.longitudeDOP);
        sb.append(", ydop=");
        sb.append(this.latitudeDOP);
        sb.append(", vdop=");
        sb.append(this.altitudeDOP);
        sb.append(", tdop=");
        sb.append(this.timestampDOP);
        sb.append(", hdop=");
        sb.append(this.horizontalDOP);
        sb.append(", pdop=");
        sb.append(this.sphericalDOP);
        sb.append(", gdop=");
        sb.append(this.hypersphericalDOP);
        sb.append(", sat=");
        sb.append(this.satellites == null ? 0 : this.satellites.size());
        sb.append("}");
        return sb.toString();
    }
}

