/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.api.IObjectListener;
import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.backend.SocketThread;
import de.taimos.gpsd4java.types.ATTObject;
import de.taimos.gpsd4java.types.DeviceObject;
import de.taimos.gpsd4java.types.DevicesObject;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import de.taimos.gpsd4java.types.PollObject;
import de.taimos.gpsd4java.types.SKYObject;
import de.taimos.gpsd4java.types.TPVObject;
import de.taimos.gpsd4java.types.VersionObject;
import de.taimos.gpsd4java.types.WatchObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class GPSdEndpoint {
    private static final Logger log = Logger.getLogger(GPSdEndpoint.class.getName());
    private final Socket socket;
    private final BufferedReader in;
    private final BufferedWriter out;
    private Thread listenThread;
    private final List<IObjectListener> listeners = new ArrayList<IObjectListener>(1);
    private IGPSObject asnycResult = null;
    private final Object asyncMutex = new Object();
    private final Object asyncWaitMutex = new Object();
    private final AbstractResultParser resultParser;

    public GPSdEndpoint(String server, int port, AbstractResultParser resultParser) throws UnknownHostException, IOException {
        if (server == null) {
            throw new IllegalArgumentException("serrver can not be null!");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal port number: " + port);
        }
        if (resultParser == null) {
            throw new IllegalArgumentException("resultParser can not be null!");
        }
        this.socket = new Socket(server, port);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.resultParser = resultParser;
    }

    public void start() {
        this.listenThread = new SocketThread(this.in, this, this.resultParser);
        this.listenThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            log.log(Level.FINE, null, e);
        }
    }

    public WatchObject watch(boolean enable, boolean dumpData) throws IOException, JSONException {
        return this.watch(enable, dumpData, null);
    }

    public WatchObject watch(boolean enable, boolean dumpData, String device) throws IOException, JSONException {
        JSONObject watch = new JSONObject();
        watch.put("class", (Object)"WATCH");
        watch.put("enable", enable);
        watch.put("json", dumpData);
        if (device != null) {
            watch.put("device", (Object)device);
        }
        return this.syncCommand("?WATCH=" + watch.toString(), WatchObject.class);
    }

    public PollObject poll() throws IOException, ParseException {
        return this.syncCommand("?POLL;", PollObject.class);
    }

    public VersionObject version() throws IOException, ParseException {
        return this.syncCommand("?VERSION;", VersionObject.class);
    }

    public void addListener(IObjectListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IObjectListener listener) {
        this.listeners.remove(listener);
    }

    private <T extends IGPSObject> T syncCommand(String command, Class<T> responseClass) throws IOException {
        Object object = this.asyncMutex;
        synchronized (object) {
            IGPSObject result;
            this.out.write(command + "\n");
            this.out.flush();
            while ((result = this.waitForResult()) != null && !result.getClass().equals(responseClass)) {
            }
            return (T)((IGPSObject)responseClass.cast(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void voidCommand(String command) throws IOException {
        Object object = this.asyncMutex;
        synchronized (object) {
            this.out.write(command + "\n");
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGPSObject waitForResult() {
        Object object = this.asyncWaitMutex;
        synchronized (object) {
            this.asnycResult = null;
            try {
                this.asyncWaitMutex.wait(1000L);
            }
            catch (InterruptedException e) {
                log.log(Level.INFO, null, e);
            }
            if (this.asnycResult != null) {
                return this.asnycResult;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(IGPSObject object) {
        if (object instanceof TPVObject) {
            for (IObjectListener l : this.listeners) {
                l.handleTPV((TPVObject)object);
            }
        } else if (object instanceof SKYObject) {
            for (IObjectListener l : this.listeners) {
                l.handleSKY((SKYObject)object);
            }
        } else if (object instanceof ATTObject) {
            for (IObjectListener l : this.listeners) {
                l.handleATT((ATTObject)object);
            }
        } else if (object instanceof DevicesObject) {
            for (IObjectListener l : this.listeners) {
                l.handleDevices((DevicesObject)object);
            }
        } else if (object instanceof DeviceObject) {
            for (IObjectListener l : this.listeners) {
                l.handleDevice((DeviceObject)object);
            }
        } else {
            Object object2 = this.asyncWaitMutex;
            synchronized (object2) {
                this.asnycResult = object;
                this.asyncWaitMutex.notifyAll();
            }
        }
    }
}

