/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.i18n.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.taimos.dvalin.i18n.II18nCallback;
import de.taimos.dvalin.i18n.II18nResourceHandler;
import de.taimos.dvalin.i18n.yaml.I18nYAMLElements;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class I18nYAMLHandler
implements II18nResourceHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="classpath*:resources/*.yaml")
    private Resource[] resourceFiles;
    private ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    @Override
    public void initializeResources(II18nCallback callback) {
        if (this.resourceFiles != null) {
            for (Resource file : this.resourceFiles) {
                this.loadResourceFile(file, callback);
            }
        }
    }

    private void loadResourceFile(Resource file, II18nCallback callback) {
        try (InputStream inParser = file.getInputStream();){
            I18nYAMLElements i18nElements = (I18nYAMLElements)this.mapper.readValue(inParser, I18nYAMLElements.class);
            callback.addText(i18nElements);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

