/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.test.inject;

import de.taimos.dvalin.test.inject.InjectionMock;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class InjectionUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(InjectionUtils.class);

    public static InjectionMock injectMocks(Object bean) {
        InjectionMock mock = new InjectionMock();
        List<Field> fields = InjectionUtils.getFields(bean.getClass());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Autowired.class)) continue;
            Qualifier qualifierAnnotation = field.getAnnotation(Qualifier.class);
            String qualifier = qualifierAnnotation == null ? null : qualifierAnnotation.value();
            Object mockObject = Mockito.mock(field.getType());
            InjectionUtils.doInjection(bean, mockObject, field);
            mock.addMock(field.getName(), mockObject, field.getType(), qualifier);
        }
        return mock;
    }

    public static void injectValue(Object bean, String field, String value) {
        try {
            Field beanField = InjectionUtils.getField(bean.getClass(), field);
            if (!beanField.isAnnotationPresent(Value.class) || !beanField.getType().equals(String.class)) {
                throw new RuntimeException("Did not find field " + field + " of type String to inject value");
            }
            InjectionUtils.doInjection(bean, value, beanField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Did not find field " + field + " to inject value");
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error injecting value due to access violation", e);
        }
    }

    public static void inject(Object bean, Object ... dependencies) {
        for (Object dependency : dependencies) {
            InjectionUtils.inject(bean, dependency);
        }
    }

    public static void inject(Object bean, Object dependency) {
        InjectionUtils.inject(bean, null, dependency);
    }

    public static void inject(Object bean, String qualifier, Object dependency) {
        List<Field> fields = InjectionUtils.getFields(bean.getClass());
        boolean found = false;
        for (Field field : fields) {
            Qualifier qualifierAnnotation;
            if (!field.isAnnotationPresent(Autowired.class) || !field.getType().isAssignableFrom(dependency.getClass()) || (qualifierAnnotation = field.getAnnotation(Qualifier.class)) != null && !qualifierAnnotation.value().equals(qualifier)) continue;
            InjectionUtils.doInjection(bean, dependency, field);
            found = true;
        }
        if (!found) {
            throw new RuntimeException("Did not find field to inject object of type " + dependency.getClass());
        }
    }

    private static void doInjection(Object bean, Object dependency, Field field) {
        try {
            LOGGER.info("Injecting object of type {} into bean of type {} in field {}", new Object[]{dependency.getClass(), bean.getClass(), field.getName()});
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(bean, dependency);
            field.setAccessible(accessible);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error injecting dependency due to access violation", e);
        }
    }

    private static List<Field> getFields(Class beanClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : beanClass.getDeclaredFields()) {
            fields.add(field);
        }
        if (!beanClass.getSuperclass().equals(Object.class)) {
            fields.addAll(InjectionUtils.getFields(beanClass.getSuperclass()));
        }
        return fields;
    }

    private static Field getField(Class beanClass, String fieldName) throws NoSuchFieldException {
        try {
            return beanClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (!beanClass.getSuperclass().equals(Object.class)) {
                return InjectionUtils.getField(beanClass.getSuperclass(), fieldName);
            }
            throw e;
        }
    }
}

