/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.test.jaxrs;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.taimos.daemon.spring.SpringDaemonExtension;
import de.taimos.dvalin.jaxrs.MapperFactory;
import de.taimos.dvalin.jaxrs.websocket.ClientSocketAdapter;
import de.taimos.httputils.HTTPRequest;
import de.taimos.httputils.HTTPResponse;
import de.taimos.httputils.WS;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Value;

@ExtendWith(value={SpringDaemonExtension.class})
public abstract class APITest {
    private static final String APPLICATION_JSON = "application/json";
    @Value(value="${server.url:http://localhost:${jaxrs.bindport:${svc.port:8080}}}")
    private String serverURL;
    @Value(value="${server.wsurl:ws://localhost:${jaxrs.bindport:${svc.port:8080}}}")
    private String websocketURL;

    protected final String getServerURL() {
        return this.serverURL;
    }

    protected String getWebSocketURL() {
        return this.websocketURL;
    }

    protected final HTTPRequest request(String path) {
        return WS.url((String)(this.serverURL + path));
    }

    protected final void assertOK(HTTPResponse res) {
        Assertions.assertTrue((boolean)res.isStatusOK(), (String)String.format("Expected OK - was %s", res.getStatus()));
    }

    protected final void assertStatus(HTTPResponse res, Response.Status status) {
        Assertions.assertEquals((int)res.getStatus(), (int)status.getStatusCode(), (String)String.format("Expected %s - was %s", status.getStatusCode(), res.getStatus()));
    }

    protected final void assertOK(Response res) {
        Assertions.assertTrue((res.getStatus() >= 200 && res.getStatus() <= 299 ? 1 : 0) != 0, (String)String.format("Expected OK - was %s", res.getStatus()));
    }

    protected final void assertStatus(Response res, Response.Status status) {
        Assertions.assertEquals((int)res.getStatus(), (int)status.getStatusCode(), (String)String.format("Expected %s - was %s", status.getStatusCode(), res.getStatus()));
    }

    protected <T> T read(HTTPResponse res, Class<T> clazz) {
        try {
            return (T)MapperFactory.createDefault().readValue(res.getResponse().getEntity().getContent(), clazz);
        }
        catch (IOException | IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> readMap(HTTPResponse res) {
        return this.read(res, Map.class);
    }

    protected HTTPRequest jsonBody(HTTPRequest req, Object o) {
        try {
            String json = MapperFactory.createDefault().writeValueAsString(o);
            return req.contentType(APPLICATION_JSON).body(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected WebSocketClient openWebsocket(String path, ClientSocketAdapter socket) {
        try {
            WebSocketClient cl = new WebSocketClient();
            cl.start();
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            socket.modifyRequest(request);
            Future socketSession = cl.connect((Object)socket, URI.create(this.getWebSocketURL() + path), request);
            socketSession.get(5L, TimeUnit.SECONDS);
            return cl;
        }
        catch (Exception e) {
            throw new RuntimeException("WebSocket failed", e);
        }
    }

    protected void print(String label, Object o) {
        try {
            String json = MapperFactory.createDefault().writeValueAsString(o);
            System.out.println(label + ": " + json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

