/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.test.jaxrs;

import de.taimos.daemon.spring.annotations.TestComponent;
import de.taimos.dvalin.test.jaxrs.TestProxy;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;

@TestComponent
public class TestProxyBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
EmbeddedValueResolverAware,
BeanFactoryAware,
Serializable {
    private transient ConfigurableListableBeanFactory beanFactory;
    private transient StringValueResolver resolver;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.buildResourceMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    private InjectionMetadata buildResourceMetadata(Class<?> clazz) {
        LinkedList elements = new LinkedList();
        Class<?> targetClass = clazz;
        do {
            LinkedList<TestProxyElement> currElements = new LinkedList<TestProxyElement>();
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(TestProxy.class)) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalStateException("@TestProxy annotation is not supported on static fields");
                }
                currElements.add(new TestProxyElement(field, null));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)accessibleObject);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)accessibleObject, (Method)bridgedMethod) || !((Method)accessibleObject).equals(ClassUtils.getMostSpecificMethod((Method)accessibleObject, clazz)) || !bridgedMethod.isAnnotationPresent(TestProxy.class)) continue;
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new IllegalStateException("@TestProxy annotation is not supported on static methods");
                }
                if (((Method)accessibleObject).getParameterTypes().length != 1) {
                    throw new IllegalStateException("@TestProxy annotation requires a single-arg method: " + accessibleObject);
                }
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, clazz);
                currElements.add(new TestProxyElement((Member)((Object)accessibleObject), pd));
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private class TestProxyElement
    extends InjectionMetadata.InjectedElement {
        public TestProxyElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
        }

        private DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new DependencyDescriptor((Field)this.member, true);
            }
            return new DependencyDescriptor(new MethodParameter((Method)this.member, 0), true);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            ArrayList<Object> providers = new ArrayList<Object>();
            try {
                String[] beans;
                String componentAnnotation = TestProxyBeanPostProcessor.this.resolver.resolveStringValue("${jaxrs.annotation:de.taimos.dvalin.jaxrs.JaxRsComponent}");
                Class<?> componentAnnotationClazz = Class.forName(componentAnnotation);
                for (String bean : beans = TestProxyBeanPostProcessor.this.beanFactory.getBeanNamesForAnnotation(componentAnnotationClazz)) {
                    if (TestProxyBeanPostProcessor.this.beanFactory.findAnnotationOnBean(bean, Provider.class) == null) continue;
                    providers.add(TestProxyBeanPostProcessor.this.beanFactory.getBean(bean));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String url = TestProxyBeanPostProcessor.this.resolver.resolveStringValue("${server.url:http://localhost:${jaxrs.bindport:${svc.port:8080}}}");
            return JAXRSClientFactory.create((String)url, (Class)this.getDependencyDescriptor().getDependencyType(), providers);
        }
    }
}

