/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.test.inject;

import java.util.HashMap;
import java.util.Map;

public class InjectionMock {
    private final Map<String, InjectedMock> mocks = new HashMap<String, InjectedMock>();

    public void addMock(String fieldName, Object mock, Class<?> targetType) {
        this.addMock(fieldName, mock, targetType, null);
    }

    public void addMock(String fieldName, Object mock, Class<?> targetType, String qualifier) {
        InjectedMock im = new InjectedMock();
        im.fieldName = fieldName;
        im.mock = mock;
        im.targetType = targetType;
        im.qualifier = qualifier;
        this.mocks.put(fieldName, im);
    }

    public Object getMock(String field) {
        return this.mocks.containsKey(field) ? this.mocks.get(field).mock : null;
    }

    public <T> T getMock(Class<T> clazz) {
        return this.getMock(clazz, null);
    }

    public <T> T getMock(Class<T> clazz, String qualifier) {
        for (InjectedMock mock : this.mocks.values()) {
            if (!mock.targetType.isAssignableFrom(clazz) || qualifier != null && !qualifier.equals(mock.qualifier)) continue;
            return (T)mock.mock;
        }
        return null;
    }

    private static class InjectedMock<T> {
        private String fieldName;
        private Class<T> targetType;
        private T mock;
        private String qualifier;

        private InjectedMock() {
        }
    }
}

