/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.orchestration.etcd.config;

import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.orchestration.core.config.ConfigListener;
import de.taimos.dvalin.orchestration.core.config.GlobalConfiguration;
import de.taimos.dvalin.orchestration.etcd.discovery.EtcdServiceDiscovery;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@OnSystemProperty(propertyName="orchestration.etcd.peers")
public class EtcdGlobalConfiguration
implements GlobalConfiguration {
    public static final Logger LOGGER = LoggerFactory.getLogger(EtcdServiceDiscovery.class);
    private static final String BASE_KEY = "/dvalin/config";
    @Value(value="${orchestration.etcd.peers}")
    private String peers;
    private EtcdClient client;
    private ConcurrentMap<String, String> configuration = new ConcurrentHashMap<String, String>();
    private final List<ConfigListener> listeners = new ArrayList<ConfigListener>();
    private final AtomicLong etcdIndex = new AtomicLong(1L);
    private final AtomicBoolean running = new AtomicBoolean(true);

    @PostConstruct
    public void init() {
        List<URI> uris = Arrays.stream(this.peers.split(",")).map(URI::create).collect(Collectors.toList());
        this.client = new EtcdClient(uris.toArray(new URI[0]));
        new Thread(() -> {
            while (this.running.get()) {
                LOGGER.debug("Polling for config updates");
                try {
                    EtcdResponsePromise send = this.client.get(BASE_KEY).waitForChange(this.etcdIndex.get()).timeout(10L, TimeUnit.SECONDS).recursive().send();
                    this.parseWaitResponse((EtcdResponsePromise<EtcdKeysResponse>)send);
                }
                catch (IOException e) {
                    LOGGER.warn("Error waiting for instance updates", (Throwable)e);
                }
            }
        }, "etcd-config-poller").start();
        this.addConfigurationListener(new ConfigListener(){

            public void added(String key, String value) {
                EtcdGlobalConfiguration.this.configuration.put(key, value);
            }

            public void changed(String key, String oldValue, String newValue) {
                EtcdGlobalConfiguration.this.configuration.put(key, newValue);
            }

            public void removed(String key, String lastValue) {
                EtcdGlobalConfiguration.this.configuration.remove(key);
            }
        });
        try {
            EtcdKeysResponse response = (EtcdKeysResponse)this.client.get(BASE_KEY).timeout(10L, TimeUnit.SECONDS).send().get();
            response.getNode().getNodes().forEach(node -> {
                String configKey = node.getKey().substring(BASE_KEY.length() + 1);
                LOGGER.debug("Population initial configuration with {} = {}", (Object)configKey, (Object)node.getValue());
                this.configuration.putIfAbsent(configKey, node.getValue());
            });
        }
        catch (Exception e) {
            LOGGER.warn("Error fetching instance data", (Throwable)e);
            this.running.set(false);
            throw new RuntimeException(e);
        }
    }

    private void parseWaitResponse(EtcdResponsePromise<EtcdKeysResponse> send) throws IOException {
        try {
            EtcdKeysResponse response = (EtcdKeysResponse)send.get();
            this.etcdIndex.set(response.node.getModifiedIndex() + 1L);
            String key = response.node.getKey();
            if (key.startsWith(BASE_KEY)) {
                String configKey = key.substring(BASE_KEY.length() + 1);
                switch (response.action) {
                    case set: 
                    case create: 
                    case update: 
                    case compareAndSwap: {
                        if (response.getPrevNode() != null) {
                            this.getListeners().forEach(l -> l.changed(configKey, response.getPrevNode().getValue(), response.getNode().getValue()));
                            break;
                        }
                        this.getListeners().forEach(l -> l.added(configKey, response.getNode().getValue()));
                        break;
                    }
                    case delete: 
                    case expire: 
                    case compareAndDelete: {
                        this.getListeners().forEach(l -> l.removed(configKey, response.getPrevNode().getValue()));
                        break;
                    }
                }
            }
        }
        catch (TimeoutException response) {
        }
        catch (EtcdAuthenticationException e) {
            LOGGER.warn("ETCD authentication error", (Throwable)e);
        }
        catch (EtcdException e) {
            if (e.getErrorCode() == 401) {
                LOGGER.info("Skipped events as index was outdated");
                this.etcdIndex.set(e.getIndex());
            }
            LOGGER.warn("ETCD error", (Throwable)e);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.listeners.clear();
        this.running.set(false);
    }

    public void setConfiguration(String key, String value) {
        try {
            this.client.put("/dvalin/config/" + key, value).timeout(10L, TimeUnit.SECONDS).send().get();
        }
        catch (Exception e) {
            LOGGER.warn("Error setting configuration data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setConfiguration(String key, String value, Integer ttlSeconds) {
        try {
            this.client.put("/dvalin/config/" + key, value).ttl(ttlSeconds).timeout(10L, TimeUnit.SECONDS).send().get();
        }
        catch (Exception e) {
            LOGGER.warn("Error setting configuration data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void removeConfiguration(String key) {
        try {
            this.client.delete("/dvalin/config/" + key).timeout(10L, TimeUnit.SECONDS).send().get();
        }
        catch (Exception e) {
            LOGGER.warn("Error removing configuration data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getConfiguration(String key) {
        return (String)this.configuration.get(key);
    }

    public void addConfigurationListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigurationListener(ConfigListener listener) {
        this.listeners.remove(listener);
    }

    private Collection<ConfigListener> getListeners() {
        return new ArrayList<ConfigListener>(this.listeners);
    }
}

