/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.monitoring.aspects;

import de.taimos.dvalin.monitoring.MetricInfo;
import de.taimos.dvalin.monitoring.MetricSender;
import de.taimos.dvalin.monitoring.MetricUnit;
import de.taimos.dvalin.monitoring.aspects.annotations.ExecutionTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class MetricAspects {
    @Autowired
    private MetricSender metricSender;
    @Value(value="${serviceName:}")
    private String serviceName;

    @Around(value="@annotation(executionTime)")
    public Object meterExecutionTime(ProceedingJoinPoint pjp, ExecutionTime executionTime) throws Throwable {
        MetricInfo info = new MetricInfo(executionTime.namespace(), executionTime.metric(), MetricUnit.Milliseconds);
        if (executionTime.serviceNameDimension() && StringUtils.hasText((String)this.serviceName)) {
            info.withDimension("service", this.serviceName);
        }
        long nanos = System.nanoTime();
        Object result = pjp.proceed();
        double time = (double)(System.nanoTime() - nanos) / 1000.0 / 1000.0;
        this.metricSender.sendMetric(info, time);
        return result;
    }
}

