/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.monitoring;

import com.google.common.base.Preconditions;
import de.taimos.dvalin.monitoring.MetricUnit;
import java.util.HashMap;
import java.util.Map;

public class MetricInfo {
    private final String namespace;
    private final String metric;
    private final Map<String, String> dimensions = new HashMap<String, String>();
    private final MetricUnit unit;

    public MetricInfo(String namespace, String metric, MetricUnit unit) {
        Preconditions.checkArgument((namespace != null && !namespace.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((metric != null && !metric.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0);
        this.namespace = namespace;
        this.metric = metric;
        this.unit = unit;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getMetric() {
        return this.metric;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public MetricInfo withDimension(String name, String value) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0);
        this.dimensions.put(name, value);
        return this;
    }
}

