/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jpa.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DatabaseConfig {
    @Value(value="${ds.package}")
    private String dsPackage;
    @Value(value="${ds.type}")
    private Database dsType;
    @Value(value="${ds.showsql:false}")
    private boolean showSQL;
    @Value(value="${ds.demodata:false}")
    private boolean demodata;

    @Bean
    public EntityManagerFactory entityManagerFactory(DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean bean = new LocalContainerEntityManagerFactoryBean();
        bean.setDataSource(dataSource);
        bean.setPersistenceUnitName("DvalinPU");
        bean.setPackagesToScan(new String[]{this.dsPackage});
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        adapter.setDatabase(this.dsType);
        adapter.setShowSql(this.showSQL);
        bean.setJpaVendorAdapter((JpaVendorAdapter)adapter);
        bean.afterPropertiesSet();
        return bean.getObject();
    }

    @Bean
    public JpaTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

    @Bean
    public SpringLiquibase liquibase(DataSource dataSource) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setChangeLog("classpath:liquibase/changelog.xml");
        return liquibase;
    }

    @Bean
    public DataSourceInitializer dataSourceInitializer(DataSource dataSource) {
        DataSourceInitializer initializer = new DataSourceInitializer();
        initializer.setDataSource(dataSource);
        initializer.setEnabled(this.demodata);
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.addScript((Resource)new ClassPathResource("sql/demodata_" + this.dsType.toString() + ".sql"));
        initializer.setDatabasePopulator((DatabasePopulator)populator);
        return initializer;
    }
}

