/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.swagger;

import de.taimos.dvalin.jaxrs.HttpProfile;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.swagger.OpenAPIProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/")
@HttpProfile
@JaxRsComponent
public class ApiListing {
    private final OpenAPIProvider openAPIProvider;

    @Autowired
    public ApiListing(OpenAPIProvider openAPIProvider) {
        this.openAPIProvider = openAPIProvider;
    }

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @Operation(hidden=true)
    @Path(value="/{a:swagger|openapi}.{type:json|yaml}")
    public Response getListing(@PathParam(value="type") String type) {
        if (StringUtils.isNotBlank((CharSequence)type) && type.trim().equalsIgnoreCase("yaml")) {
            return this.getListingYaml();
        }
        return this.getListingJson();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{a:swagger|openapi}")
    @Operation(hidden=true)
    public Response getListingJson() {
        OpenAPI openAPI = this.openAPIProvider.process();
        if (openAPI != null) {
            return Response.ok().entity((Object)openAPI).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.status((int)404).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="/{a:swagger|openapi}")
    @Operation(hidden=true)
    public Response getListingYaml() {
        OpenAPI openAPI = this.openAPIProvider.process();
        if (openAPI != null) {
            return Response.ok().entity((Object)openAPI).type("application/yaml").build();
        }
        return Response.status((int)404).build();
    }
}

