/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.jwt.cognito;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.security.jwt.IJWTAuth;
import de.taimos.dvalin.jaxrs.security.jwt.JWKSKeyLoader;
import de.taimos.dvalin.jaxrs.security.jwt.cognito.CognitoUser;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;

@JaxRsComponent
@OnSystemProperty(propertyName="jwtauth.cognito.poolid")
public class CognitoJWTAuth
implements IJWTAuth {
    @Value(value="${jwtauth.cognito.poolid}")
    private String cognitoPoolId;
    @Value(value="${jwtauth.cognito.region}")
    private String cognitoPoolRegion;
    @Value(value="${jwtauth.cognito.roles:cognito:groups}")
    private String cognitoRoles;
    private String issuer;
    private LoadingCache<String, RSAKey> jwtKeyCache;

    @PostConstruct
    public void init() {
        this.issuer = "https://cognito-idp." + this.cognitoPoolRegion + ".amazonaws.com/" + this.cognitoPoolId;
        this.jwtKeyCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new JWKSKeyLoader(this.issuer));
    }

    @Override
    public CognitoUser validateToken(String jwtString) throws ParseException {
        SignedJWT jwt = SignedJWT.parse((String)jwtString);
        if (!jwt.getJWTClaimsSet().getIssuer().equals(this.issuer)) {
            throw new IllegalArgumentException("Invalid issuer for JWT: " + jwt.getJWTClaimsSet().getIssuer());
        }
        String tokenUse = jwt.getJWTClaimsSet().getStringClaim("token_use");
        if (!tokenUse.equals("access") && !tokenUse.equals("id")) {
            throw new IllegalArgumentException("Invalid token usage type: " + tokenUse);
        }
        String kid = jwt.getHeader().getKeyID();
        RSAKey key = (RSAKey)this.jwtKeyCache.getUnchecked((Object)kid);
        if (key == null) {
            throw new IllegalArgumentException("No key for kid: " + kid);
        }
        try {
            JWTClaimsSet claims;
            if (jwt.verify((JWSVerifier)new RSASSAVerifier(key)) && !(claims = jwt.getJWTClaimsSet()).getExpirationTime().before(new Date())) {
                return CognitoUser.parseClaims(claims, this.cognitoRoles);
            }
            return null;
        }
        catch (JOSEException e) {
            throw new IllegalArgumentException("Cannot verify JWT", e);
        }
    }
}

