/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.jwt.cognito;

import com.nimbusds.jwt.JWTClaimsSet;
import de.taimos.dvalin.jaxrs.security.IUser;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CognitoUser
implements IUser {
    private String subject;
    private String email;
    private boolean emailVerified;
    private String username;
    private String[] roles;
    private Map<String, Object> customFields = new HashMap<String, Object>();

    public String getSubject() {
        return this.subject;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public String getUsername() {
        return this.username;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        return "CognitoUser{subject='" + this.subject + '\'' + ", email='" + this.email + '\'' + ", emailVerified=" + this.emailVerified + ", username='" + this.username + '\'' + ", roles=" + Arrays.toString(this.roles) + ", customFields=" + this.customFields + '}';
    }

    public static CognitoUser parseClaims(JWTClaimsSet claims, String rolesField) throws ParseException {
        CognitoUser user = new CognitoUser();
        user.subject = claims.getSubject();
        user.roles = claims.getStringArrayClaim(rolesField);
        user.customFields = claims.getClaims();
        switch (claims.getStringClaim("token_use")) {
            case "id": {
                user.username = claims.getStringClaim("cognito:username");
                user.email = claims.getStringClaim("email");
                user.emailVerified = claims.getBooleanClaim("email_verified");
                break;
            }
            case "access": {
                user.username = claims.getStringClaim("username");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid token use: " + claims.getStringClaim("token_use"));
            }
        }
        return user;
    }
}

