/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.jwt.auth0;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.security.jwt.IJWTAuth;
import de.taimos.dvalin.jaxrs.security.jwt.JWKSKeyLoader;
import de.taimos.dvalin.jaxrs.security.jwt.auth0.Auth0User;
import de.taimos.httputils.HTTPResponse;
import de.taimos.httputils.WS;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;

@JaxRsComponent
@OnSystemProperty(propertyName="jwtauth.auth0.issuer")
public class Auth0JWTAuth
implements IJWTAuth {
    @Value(value="${jwtauth.auth0.issuer}")
    private String issuer;
    @Value(value="${jwtauth.auth0.audience}")
    private String audience;
    private LoadingCache<String, RSAKey> jwtKeyCache;

    @PostConstruct
    public void init() {
        this.jwtKeyCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new JWKSKeyLoader(this.issuer));
    }

    @Override
    public Auth0User validateToken(String jwtString) throws java.text.ParseException {
        SignedJWT jwt = SignedJWT.parse((String)jwtString);
        if (!jwt.getJWTClaimsSet().getIssuer().equals(this.issuer)) {
            throw new IllegalArgumentException("Invalid issuer for JWT: " + jwt.getJWTClaimsSet().getIssuer());
        }
        if (!jwt.getJWTClaimsSet().getAudience().contains(this.audience)) {
            throw new IllegalArgumentException("Invalid audience for JWT: " + jwt.getJWTClaimsSet().getAudience());
        }
        String kid = jwt.getHeader().getKeyID();
        RSAKey key = (RSAKey)this.jwtKeyCache.getUnchecked((Object)kid);
        if (key == null) {
            throw new IllegalArgumentException("No key for kid: " + kid);
        }
        try {
            JWTClaimsSet claims;
            if (jwt.verify((JWSVerifier)new RSASSAVerifier(key)) && !(claims = jwt.getJWTClaimsSet()).getExpirationTime().before(new Date())) {
                return Auth0User.parseClaims(claims, jwtString);
            }
            return null;
        }
        catch (JOSEException e) {
            throw new IllegalArgumentException("Cannot verify JWT", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> retrieveUserProfile(Auth0User user) {
        try (HTTPResponse httpResponse = WS.url((String)(this.issuer + "userinfo")).authBearer(user.getToken()).retry().get();){
            JSONObject jSONObject = (JSONObject)new JSONParser(-1).parse(httpResponse.getResponseAsBytes());
            return jSONObject;
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not parse user info", e);
        }
    }
}

