/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.context.DvalinRSContext;
import de.taimos.dvalin.jaxrs.security.jwt.AuthenticatedUser;
import de.taimos.dvalin.jaxrs.security.jwt.IJWTAuth;
import java.text.ParseException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@JaxRsComponent
@OnSystemProperty(propertyName="jwtauth.secret")
public class JWTAuth
implements IJWTAuth {
    @Value(value="${jwtauth.secret}")
    private String jwtSharedSecret;
    @Value(value="${jwtauth.timeout:3600000}")
    private Long jwtTimeout;
    @Value(value="${jwtauth.issuer}")
    private String jwtIssuer;
    @Autowired
    private DvalinRSContext context;

    public SignedJWT signToken(JWTClaimsSet claims) {
        try {
            SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claims);
            signedJWT.sign((JWSSigner)new MACSigner(this.jwtSharedSecret));
            return signedJWT;
        }
        catch (JOSEException e) {
            throw new RuntimeException("Error signing JSON Web Token", e);
        }
    }

    public String signToken(AuthenticatedUser user) {
        Date expiry = new Date(System.currentTimeMillis() + this.jwtTimeout);
        JWTClaimsSet claimsSet = user.toClaimSet(this.jwtIssuer, expiry);
        SignedJWT jwt = this.signToken(claimsSet);
        return jwt.serialize();
    }

    public SignedJWT verifyToken(String jwtString) throws ParseException {
        try {
            SignedJWT jwt = SignedJWT.parse((String)jwtString);
            if (jwt.verify((JWSVerifier)new MACVerifier(this.jwtSharedSecret))) {
                return jwt;
            }
            return null;
        }
        catch (JOSEException e) {
            throw new RuntimeException("Error verifying JSON Web Token", e);
        }
    }

    @Override
    public AuthenticatedUser validateToken(String jwtString) throws ParseException {
        SignedJWT jwt = this.verifyToken(jwtString);
        JWTClaimsSet claims = jwt.getJWTClaimsSet();
        if (claims.getExpirationTime().before(new Date())) {
            return null;
        }
        return new AuthenticatedUser(claims);
    }

    public AuthenticatedUser getCurrentUser() {
        return (AuthenticatedUser)this.context.getCurrentUser();
    }
}

