/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.jwt;

import com.google.common.cache.CacheLoader;
import com.nimbusds.jose.jwk.RSAKey;
import de.taimos.httputils.HTTPResponse;
import de.taimos.httputils.WS;
import javax.annotation.Nonnull;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class JWKSKeyLoader
extends CacheLoader<String, RSAKey> {
    private final String issuer;

    public JWKSKeyLoader(String issuer) {
        this.issuer = issuer;
    }

    public RSAKey load(@Nonnull String keyId) throws Exception {
        JSONObject jwksBody;
        HTTPResponse httpResponse = WS.url((String)(this.issuer + "/.well-known/jwks.json")).accept("application/json").retry().get();
        Object object = null;
        try {
            jwksBody = (JSONObject)new JSONParser(-1).parse(httpResponse.getResponseAsBytes());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (httpResponse != null) {
                if (object != null) {
                    try {
                        httpResponse.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    httpResponse.close();
                }
            }
        }
        JSONArray keys = (JSONArray)jwksBody.get((Object)"keys");
        for (Object key : keys) {
            RSAKey jwk = RSAKey.parse((JSONObject)((JSONObject)key));
            if (!jwk.getKeyID().equals(keyId)) continue;
            return jwk;
        }
        throw new RuntimeException("Key not found");
    }
}

