/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.jwt.cognito;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.security.jwt.IJWTAuth;
import de.taimos.dvalin.jaxrs.security.jwt.cognito.CognitoUser;
import de.taimos.httputils.WS;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.http.HttpResponse;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Value;

@JaxRsComponent
@OnSystemProperty(propertyName="jwtauth.cognito.poolid")
public class CognitoJWTAuth
implements IJWTAuth {
    @Value(value="${jwtauth.cognito.poolid}")
    private String cognitoPoolId;
    @Value(value="${jwtauth.cognito.region}")
    private String cognitoPoolRegion;
    @Value(value="${jwtauth.cognito.roles:cognito:groups}")
    private String cognitoRoles;
    private String issuer;
    private final Map<String, RSAKey> webKeys = new HashMap<String, RSAKey>();

    @PostConstruct
    public void init() {
        try {
            this.issuer = "https://cognito-idp." + this.cognitoPoolRegion + ".amazonaws.com/" + this.cognitoPoolId;
            HttpResponse httpResponse = WS.url((String)(this.issuer + "/.well-known/jwks.json")).accept("application/json").get();
            JSONObject jwksBody = (JSONObject)new JSONParser(-1).parse(WS.getResponseAsBytes((HttpResponse)httpResponse));
            JSONArray keys = (JSONArray)jwksBody.get((Object)"keys");
            for (Object key : keys) {
                RSAKey jwk = RSAKey.parse((JSONObject)((JSONObject)key));
                this.webKeys.put(jwk.getKeyID(), jwk);
            }
        }
        catch (java.text.ParseException | ParseException e) {
            throw new BeanInitializationException("Cannot load secrets from WS Cognito User Pool", e);
        }
    }

    @Override
    public CognitoUser validateToken(String jwtString) throws java.text.ParseException {
        SignedJWT jwt = SignedJWT.parse((String)jwtString);
        if (!jwt.getJWTClaimsSet().getIssuer().equals(this.issuer)) {
            throw new IllegalArgumentException("Invalid issuer for JWT: " + jwt.getJWTClaimsSet().getIssuer());
        }
        String tokenUse = jwt.getJWTClaimsSet().getStringClaim("token_use");
        if (!tokenUse.equals("access") && !tokenUse.equals("id")) {
            throw new IllegalArgumentException("Invalid token usage type: " + tokenUse);
        }
        String kid = jwt.getHeader().getKeyID();
        if (!this.webKeys.containsKey(kid)) {
            throw new IllegalArgumentException("No key for kid: " + kid);
        }
        try {
            JWTClaimsSet claims;
            if (jwt.verify((JWSVerifier)new RSASSAVerifier(this.webKeys.get(kid))) && !(claims = jwt.getJWTClaimsSet()).getExpirationTime().before(new Date())) {
                return CognitoUser.parseClaims(claims, this.cognitoRoles);
            }
            return null;
        }
        catch (JOSEException e) {
            throw new IllegalArgumentException("Cannot verify JWT", e);
        }
    }
}

