/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring.test;

import com.google.common.collect.Maps;
import de.taimos.daemon.spring.annotations.TestComponent;
import de.taimos.dvalin.interconnect.core.spring.requestresponse.IRequestMock;
import de.taimos.dvalin.interconnect.core.spring.test.APrototypeHandlerMock;
import de.taimos.dvalin.interconnect.core.spring.test.ASingletonHandlerMock;
import de.taimos.dvalin.interconnect.model.InterconnectContext;
import de.taimos.dvalin.interconnect.model.InterconnectList;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.service.Daemon;
import de.taimos.dvalin.interconnect.model.service.DaemonError;
import de.taimos.dvalin.interconnect.model.service.DaemonScanner;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TestComponent(value="requestMock")
public class InterconnectRequestMock
implements IRequestMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterconnectRequestMock.class);
    private final ConcurrentHashMap<String, RequestMockHandler> handlers = new ConcurrentHashMap();
    @Autowired
    private ListableBeanFactory beanFactory;

    @PostConstruct
    public void init() {
        String[] singletonNames;
        String[] prototypeNames;
        for (String name : prototypeNames = this.beanFactory.getBeanNamesForType(APrototypeHandlerMock.class)) {
            Class type = this.beanFactory.getType(name);
            LOGGER.info("Found request mock of type {} with name {}", (Object)type, (Object)name);
            this.registerPrototype(type, name);
        }
        for (String name : singletonNames = this.beanFactory.getBeanNamesForType(ASingletonHandlerMock.class)) {
            Class type = this.beanFactory.getType(name);
            LOGGER.info("Found request mock of type {} with name {}", (Object)type, (Object)name);
            this.registerSingleton(type, name);
        }
    }

    private static String getQueueName(Class<?>[] interfaces) {
        for (Class<?> iface : interfaces) {
            if (!iface.isAnnotationPresent(Daemon.class)) continue;
            return iface.getAnnotation(Daemon.class).name() + ".request";
        }
        throw new RuntimeException("No @Daemon annotation found");
    }

    private void registerPrototype(Class<? extends APrototypeHandlerMock> handler, String beanName) {
        Class<?>[] interfaces = handler.getInterfaces();
        String queueName = InterconnectRequestMock.getQueueName(interfaces);
        this.handlers.put(queueName, new RMHWrapper(handler, beanName, (BeanFactory)this.beanFactory, false));
    }

    private void registerSingleton(Class<? extends ASingletonHandlerMock> handler, String beanName) {
        Class<?>[] interfaces = handler.getInterfaces();
        String queueName = InterconnectRequestMock.getQueueName(interfaces);
        this.handlers.put(queueName, new RMHWrapper(handler, beanName, (BeanFactory)this.beanFactory, true));
    }

    public boolean hasHandler(String queue) {
        return this.handlers.containsKey(queue);
    }

    @Override
    public <R> R in(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz) throws DaemonError {
        return this.request(uuid, queue, request, responseClazz);
    }

    public <R> R request(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz) throws DaemonError {
        RequestMockHandler handler = this.handlers.get(queue);
        if (handler != null) {
            return handler.handle(uuid, request, responseClazz);
        }
        throw new RuntimeException("No handler for queue: " + queue + " and request: " + request);
    }

    @Override
    public void in(UUID uuid, String queue, InterconnectObject request) {
        this.receive(uuid, queue, request);
    }

    public void receive(UUID uuid, String queue, InterconnectObject request) {
        RequestMockHandler handler = this.handlers.get(queue);
        if (handler == null) {
            throw new RuntimeException("No handler for queue: " + queue + " and request: " + request);
        }
        handler.handle(uuid, request);
    }

    public static class RMHWrapper
    implements RequestMockHandler {
        private final Map<Class<? extends InterconnectObject>, DaemonScanner.DaemonMethod> methods = Maps.newHashMap();
        private final BeanFactory beanFactory;
        private final String beanName;
        private final boolean singleton;

        public RMHWrapper(Class<? extends IDaemonHandler> handler, String beanName, BeanFactory beanFactory, boolean singleton) {
            this.beanName = beanName;
            this.beanFactory = beanFactory;
            Set scan = DaemonScanner.scan(handler);
            for (DaemonScanner.DaemonMethod dm : scan) {
                this.methods.put(dm.getRequest(), dm);
            }
            this.singleton = singleton;
        }

        @Override
        public <R> R handle(UUID uuid, InterconnectObject ico, Class<R> responseClazz) throws DaemonError {
            DaemonScanner.DaemonMethod daemonMethod = this.methods.get(ico.getClass());
            if (daemonMethod != null) {
                try {
                    IDaemonHandler mockInstance = this.createMockInstance(ico.getClass(), uuid);
                    InterconnectObject ivo = daemonMethod.invoke(mockInstance, ico);
                    if (responseClazz.isArray() && ivo instanceof InterconnectList) {
                        InterconnectList list = (InterconnectList)ivo;
                        Object obj = Array.newInstance(responseClazz.getComponentType(), list.getElements().size());
                        return (R)list.getElements().toArray(DaemonScanner.object2Array(responseClazz.getComponentType(), (Object)obj));
                    }
                    if (ivo instanceof InterconnectList && List.class.isAssignableFrom(responseClazz)) {
                        InterconnectList list = (InterconnectList)ivo;
                        return (R)list.getElements();
                    }
                    if (responseClazz.isAssignableFrom(ivo.getClass())) {
                        return responseClazz.cast(ivo);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof DaemonError) {
                        throw (DaemonError)e.getTargetException();
                    }
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException();
        }

        @Override
        public void handle(UUID uuid, InterconnectObject ico) {
            DaemonScanner.DaemonMethod daemonMethod = this.methods.get(ico.getClass());
            if (daemonMethod != null) {
                try {
                    IDaemonHandler mockInstance = this.createMockInstance(ico.getClass(), uuid);
                    if (daemonMethod.invoke(mockInstance, ico) == null) {
                        return;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException();
        }

        private IDaemonHandler createMockInstance(Class<? extends InterconnectObject> ivoClass, UUID uuid) {
            InterconnectContext.reset();
            InterconnectContext.setUuid((UUID)uuid);
            if (IVO.class.isAssignableFrom(ivoClass)) {
                InterconnectContext.setRequestClass(ivoClass);
            } else {
                InterconnectContext.setRequestClass(IVO.class);
            }
            Object mockInstance = this.singleton ? (ASingletonHandlerMock)this.beanFactory.getBean(this.beanName) : (APrototypeHandlerMock)this.beanFactory.getBean(this.beanName);
            return mockInstance;
        }
    }

    public static interface RequestMockHandler {
        public <R> R handle(UUID var1, InterconnectObject var2, Class<R> var3) throws DaemonError;

        public void handle(UUID var1, InterconnectObject var2);
    }
}

