/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring.test;

import de.taimos.dvalin.interconnect.core.spring.DaemonMessageSenderHeader;
import de.taimos.dvalin.interconnect.core.spring.test.InterconnectRequestMock;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BrokerMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerMock.class);
    private final ConcurrentHashMap<String, MessageListener> listeners = new ConcurrentHashMap();
    private final Executor exec = Executors.newCachedThreadPool();
    @Autowired
    private InterconnectRequestMock requestMock;

    public BrokerMock(Map<String, MessageListener> listeners) {
        this.listeners.putAll(listeners);
    }

    public void send(String destination, boolean topic, InterconnectObject ico, DaemonMessageSenderHeader ... headers) {
        if (this.requestMock.hasHandler(destination)) {
            UUID uuid = null;
            for (DaemonMessageSenderHeader head : headers) {
                if (head.getField() != DaemonMessageSenderHeader.Field.RequestUUID) continue;
                uuid = UUID.fromString((String)head.getValue());
            }
            this.requestMock.receive(uuid == null ? UUID.randomUUID() : uuid, destination, ico);
            return;
        }
        String destName = (topic ? "topic://" : "queue://") + destination;
        if (!this.listeners.containsKey(destName)) {
            LOGGER.error("Missing destination {}", (Object)destName);
            throw new RuntimeException();
        }
        this.exec.execute(() -> {
            try {
                Object dest = topic ? new ActiveMQTopic(destination) : new ActiveMQQueue(destination);
                ActiveMQTextMessage msg = new ActiveMQTextMessage();
                msg.setDestination((ActiveMQDestination)dest);
                msg.setText(InterconnectMapper.toJson((InterconnectObject)ico));
                msg.setObjectProperty("InterconnectICOClass", (Object)ico.getClass().getName());
                if (headers != null) {
                    for (DaemonMessageSenderHeader header : headers) {
                        msg.setObjectProperty(header.getField().getName(), header.getValue());
                    }
                }
                this.listeners.get(destName).onMessage((Message)msg);
            }
            catch (Exception e) {
                LOGGER.error("Failed to send message", (Throwable)e);
            }
        });
    }
}

