/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring.message;

import de.taimos.daemon.spring.annotations.TestComponent;
import de.taimos.dvalin.interconnect.core.daemon.DaemonResponse;
import de.taimos.dvalin.interconnect.core.spring.DaemonMessageSenderHeader;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.core.spring.message.IMessageMock;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import javax.jms.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TestComponent
public final class DaemonMessageSenderMock
implements IDaemonMessageSender {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private IMessageMock messageMock;

    public DaemonMessageSenderMock() {
        this.logger.trace("new bean instance created");
    }

    public void reply(DaemonResponse response) throws Exception {
        this.reply(response, false);
    }

    public void reply(String correlationID, Destination replyTo, InterconnectObject ico) throws Exception {
        this.reply(correlationID, replyTo, ico, false);
    }

    public void reply(DaemonResponse response, boolean secure) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void reply(String correlationID, Destination replyTo, InterconnectObject ico, boolean secure) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void sendToTopic(String topic, InterconnectObject ico, DaemonMessageSenderHeader ... headers) throws Exception {
        this.sendToTopic(topic, ico, false, headers);
    }

    public void sendToQueue(String queue, InterconnectObject ico, DaemonMessageSenderHeader ... headers) throws Exception {
        this.sendToQueue(queue, ico, false, headers);
    }

    public void sendToTopic(String topic, InterconnectObject ico, boolean secure, DaemonMessageSenderHeader ... headers) throws Exception {
        if (this.messageMock == null) {
            throw new UnsupportedOperationException("No messageMock");
        }
        this.messageMock.sendToTopic(topic, ico, headers);
    }

    public void sendToQueue(String queue, InterconnectObject ico, boolean secure, DaemonMessageSenderHeader ... headers) throws Exception {
        if (this.messageMock == null) {
            throw new UnsupportedOperationException("No messageMock");
        }
        this.messageMock.sendToQueue(queue, ico, null, headers);
    }

    public void sendToQueue(String queue, InterconnectObject ico, boolean secure, String replyToQueue, String correlationId, DaemonMessageSenderHeader ... headers) throws Exception {
        if (this.messageMock == null) {
            throw new UnsupportedOperationException("No messageMock");
        }
        this.messageMock.sendToQueue(queue, ico, correlationId, headers);
    }
}

