package de.taimos.dvalin.interconnect.demo.model.requests;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import de.taimos.dvalin.interconnect.demo.model.UserIVO_v1;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonDeserialize(builder = DeleteUserIVO_v1.DeleteUserIVO_v1Builder.class)
public class DeleteUserIVO_v1 extends AbstractIVO implements IDeleteUserIVO_v1 {

private static final long serialVersionUID = 1L;

	/**
	* Builder for the read-only ivo
	*
	*/
	@JsonPOJOBuilder()
	public static class DeleteUserIVO_v1Builder extends AbstractDeleteUserIVO_v1Builder<DeleteUserIVO_v1Builder> implements IVOBuilder {

		// nothing to do here, really

	}

	/**
	* Abstract Builder for the read-only ivo
	*
	* @param <E> type of builder
	*/
	public abstract static class AbstractDeleteUserIVO_v1Builder<E extends AbstractDeleteUserIVO_v1Builder<?>>   {
		private String id;
		/**
		 * This field is required.
		 * the id
		 *
		 * @param id the value to set
		 * @return the builder
		 *
		 **/
		@Nonnull
		@SuppressWarnings("unchecked")
		public E withId(String id) {
			this.id = id;
			return (E) this;
		}


		protected void internalFillFromIVO(DeleteUserIVO_v1 ivo) {
			this.withId(ivo.id);
		}

		/**
		 * @return the entry
		 **/
		public DeleteUserIVO_v1 build() {
			if (this.id == null) {
				throw new IllegalStateException("The attribute id must not be null!");
			}
			DeleteUserIVO_v1 result = new DeleteUserIVO_v1(this);
			return result;
		}
	}

	private final  String id;

	protected DeleteUserIVO_v1(AbstractDeleteUserIVO_v1Builder<?> builder) {
		this.id = builder.id;
	}

	public String getId() {
		return this.id;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends IVOBuilder> T createBuilder() {
		DeleteUserIVO_v1Builder builder = new DeleteUserIVO_v1Builder();
		builder.internalFillFromIVO(this);
		return (T) builder;
	}

	@Override
	public DeleteUserIVO_v1 clone() {
		return (DeleteUserIVO_v1) super.clone();
	}


	@Override
	public String toString() {
		return this.getClass().getName() + " " + this.id;
	}

	@Override
	public boolean equals(Object obj) {
		if(obj instanceof DeleteUserIVO_v1) {
			return this.id.equals(((DeleteUserIVO_v1)obj).id);
		}
		return false;
	}
}
