package de.taimos.dvalin.interconnect.demo.model.requests;

import de.taimos.dvalin.interconnect.model.ivo.Direction;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IPageable;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Set;
import de.taimos.dvalin.interconnect.demo.model.UserIVO_v1;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "@class")
public interface IFindUserIVO_v1 extends de.taimos.dvalin.interconnect.model.ivo.IPageable {


	/**
	 * the maximum result size
	 * This field is optional, thus may be null.
	 *
	 * @return the value for limit
	 *
	 **/
	@Nullable
	public Integer getLimit();

	/**
	 * the offset of the first result
	 * This field is optional, thus may be null.
	 *
	 * @return the value for offset
	 *
	 **/
	@Nullable
	public Integer getOffset();

	/**
	 * provide this to enable a correct sorted paging of your lists. Use {@link #withSortDirection(Direction)} to provide information about sort direction
	 * This field is optional, thus may be null.
	 *
	 * @return the value for sortBy
	 *
	 **/
	@Nullable
	public String getSortBy();

	/**
	 * provide this to enable a correct sorted paging of your lists. Use {@link #withSortBy(String)} to provide information about the property to sort by
	 * This field is optional, thus may be null.
	 *
	 * @return the value for sortDirection
	 *
	 **/
	@Nullable
	public Direction getSortDirection();

	/**
	 * the name of the user
	 * This field is optional, thus may be null.
	 *
	 * @return the value for name
	 *
	 **/
	@Nullable
	public Set<String> getName();

	/**
	 * the city of the user
	 * This field is optional, thus may be null.
	 *
	 * @return the value for city
	 *
	 **/
	@Nullable
	public String getCity();



	/**
	 * @return a clone
	 */
	public IFindUserIVO_v1 clone();

}
