package de.taimos.dvalin.interconnect.demo.model.requests;

import de.taimos.dvalin.interconnect.model.ivo.IPageableBuilder;
import de.taimos.dvalin.interconnect.model.ivo.Direction;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IPageable;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Set;
import de.taimos.dvalin.interconnect.demo.model.UserIVO_v1;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonDeserialize(builder = FindUserIVO_v1.FindUserIVO_v1Builder.class)
public class FindUserIVO_v1 extends AbstractIVO implements IFindUserIVO_v1 {

private static final long serialVersionUID = 1L;

	/**
	* Builder for the read-only ivo
	*
	*/
	@JsonPOJOBuilder()
	public static class FindUserIVO_v1Builder extends AbstractFindUserIVO_v1Builder<FindUserIVO_v1Builder> implements IVOBuilder {

		// nothing to do here, really

	}

	/**
	* Abstract Builder for the read-only ivo
	*
	* @param <E> type of builder
	*/
	public abstract static class AbstractFindUserIVO_v1Builder<E extends AbstractFindUserIVO_v1Builder<?>>  implements IPageableBuilder {
		private Integer limit;
		private Integer offset;
		private String sortBy;
		private Direction sortDirection;
		private Set<String> name;
		private String city;

		/**
		 * This field is optional.
		 * @param  limit the value to set
		 * @return the builder single
		 *
		 **/
	 	@Nullable
		public E withLimit(Integer plimit) {
			this.limit = plimit;
			return (E) this;
		}


		/**
		 * @return the field value
		 **/
		public Integer getLimit() {
			return this.limit;
		}
		/**
		 * This field is optional.
		 * @param  offset the value to set
		 * @return the builder single
		 *
		 **/
	 	@Nullable
		public E withOffset(Integer poffset) {
			this.offset = poffset;
			return (E) this;
		}


		/**
		 * @return the field value
		 **/
		public Integer getOffset() {
			return this.offset;
		}
		/**
		 * This field is optional.
		 * @param  sortBy the value to set
		 * @return the builder single
		 *
		 **/
	 	@Nullable
		public E withSortBy(String psortBy) {
			this.sortBy = psortBy;
			return (E) this;
		}


		/**
		 * @return the field value
		 **/
		public String getSortBy() {
			return this.sortBy;
		}
		/**
		 * This field is optional.
		 * @param  sortDirection the value to set
		 * @return the builder single
		 *
		 **/
	 	@Nullable
		public E withSortDirection(Direction psortDirection) {
			this.sortDirection = psortDirection;
			return (E) this;
		}


		/**
		 * @return the field value
		 **/
		public Direction getSortDirection() {
			return this.sortDirection;
		}
		/**
		 * This field is optional.
		 * @param  name the value to set
		 * @return the builder multi
		 *
		 **/
	 	@Nullable
		public E withName(Set<String> pname) {
			this.name = pname;
			return (E) this;
		}


		/**
		 * @return the field value
		 **/
		public Set<String> getName() {
			return this.name;
		}
		/**
		 * This field is optional.
		 * @param  city the value to set
		 * @return the builder single
		 *
		 **/
	 	@Nullable
		public E withCity(String pcity) {
			this.city = pcity;
			return (E) this;
		}


		/**
		 * @return the field value
		 **/
		public String getCity() {
			return this.city;
		}

		protected void internalFillFromIVO(FindUserIVO_v1 ivo) {
		this.withLimit(ivo.limit);
		this.withOffset(ivo.offset);
		this.withSortBy(ivo.sortBy);
		this.withSortDirection(ivo.sortDirection);
		this.withName(ivo.name);
		this.withCity(ivo.city);
		}

		/**
		 * @return the entry
		 **/
		public FindUserIVO_v1 build() {
			FindUserIVO_v1 result = new FindUserIVO_v1(this);
			return result;
		}
	}

	private final  Integer limit;
	private final  Integer offset;
	private final  String sortBy;
	private final  Direction sortDirection;
	private final  Set<String> name;
	private final  String city;


	protected FindUserIVO_v1(AbstractFindUserIVO_v1Builder<?> builder) {
		this.limit = builder.limit;
		this.offset = builder.offset;
		this.sortBy = builder.sortBy;
		this.sortDirection = builder.sortDirection;
		this.name = builder.name;
		this.city = builder.city;
	}

	@Override
	public Integer getLimit() {
		return this.limit;
	}

	@Override
	public Integer getOffset() {
		return this.offset;
	}

	@Override
	public String getSortBy() {
		return this.sortBy;
	}

	@Override
	public Direction getSortDirection() {
		return this.sortDirection;
	}

	@Override
	public Set<String> getName() {
		return this.name;
	}

	@Override
	public String getCity() {
		return this.city;
	}


	@SuppressWarnings("unchecked")
	@Override
	public IPageableBuilder createPageableBuilder() {
		return (IPageableBuilder) createBuilder();
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends IVOBuilder> T createBuilder() {
		FindUserIVO_v1Builder builder = new FindUserIVO_v1Builder();
		builder.internalFillFromIVO(this);
		return (T) builder;
	}

	@Override
	public FindUserIVO_v1 clone() {
		return (FindUserIVO_v1) super.clone();
	}

}
