package de.taimos.dvalin.interconnect.demo.model;

import de.taimos.dvalin.interconnect.model.ivo.IVO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonDeserialize(builder = RegUserIVO_v1.RegUserIVO_v1Builder.class)
public class RegUserIVO_v1 extends AbstractIVO implements IRegUserIVO_v1 {

	private static final long serialVersionUID = 1L;

	/**
	* Builder for the read-only ivo
	*
	*/
	@JsonPOJOBuilder()
	public static class RegUserIVO_v1Builder extends AbstractRegUserIVO_v1Builder<RegUserIVO_v1Builder> implements IVOBuilder {

		// nothing to do here, really

	}


	/**
	* Abstract Builder for the read-only ivo
	*
	* @param <E> type of builder
	*/
	public abstract static class AbstractRegUserIVO_v1Builder<E extends AbstractRegUserIVO_v1Builder<?>>   {

		private Long userId;
		private String name;
		/**
		 * This field is required.
		 * the users id
		 *
		 * @param puserId the value to set
		 * @return the builder
		 *
		 **/
		@Nonnull
		@SuppressWarnings("unchecked")
		public E withUserId(Long puserId) {
			this.userId = puserId;
			return (E) this;
		}

		/**
		 * @return the field value
		 **/
		public Long getUserId() {
			return this.userId;
		}

		/**
		 * This field is required.
		 * the name of the user
		 *
		 * @param pname the value to set
		 * @return the builder
		 *
		 **/
		@Nonnull
		@SuppressWarnings("unchecked")
		public E withName(String pname) {
			this.name = pname;
			return (E) this;
		}

		/**
		 * @return the field value
		 **/
		public String getName() {
			return this.name;
		}


		protected void internalFillFromIVO(RegUserIVO_v1 ivo) {
			this.withUserId(ivo.userId);
			this.withName(ivo.name);
		}

		/**
		 * @return the entry
		 **/
		public RegUserIVO_v1 build() {
			if (this.userId == null) {
				throw new IllegalStateException("The attribute userId must not be null!");
			}
			if (this.name == null) {
				throw new IllegalStateException("The attribute name must not be null!");
			}
			RegUserIVO_v1 result = new RegUserIVO_v1(this);
			return result;
		}

	}

	private final  Long userId;
	private final  String name;

	protected RegUserIVO_v1(AbstractRegUserIVO_v1Builder<?> builder) {
		this.userId = builder.userId;
		this.name = builder.name;
	}

	@Override
	public Long getUserId() {
		return this.userId;
	}

	@Override
	public String getName() {
		return this.name;
	}


	@SuppressWarnings("unchecked")
	@Override
	public <T extends IVOBuilder> T createBuilder() {
		RegUserIVO_v1Builder builder = new RegUserIVO_v1Builder();
		builder.internalFillFromIVO(this);
		return (T) builder;
	}



	@Override
	public RegUserIVO_v1 clone() {
		return (RegUserIVO_v1) super.clone();
	}


}
