package de.taimos.dvalin.interconnect.demo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "@class")
public interface IUserIVO_v1  {

	/**
	 * property constant for name
	 * property comment: the name of the user
	 */
	public static final String PROP_NAME = "name";
	/**
	 * property constant for city
	 * property comment: the city of the user
	 */
	public static final String PROP_CITY = "city";

	/**
	 * property constant for the id
	 */
	public static final String PROP_ID = "id";

	/**
	 * the id
	 *
	 * @return the value for id
	 *
	 **/
	public String getId();

	/**
	 * the id as long
	 *
	 * @return the value for id
	 *
	 **/
	@JsonIgnore
	public long getIdAsLong();

	/**
	 * the name of the user
	 * This field is required.
	 *
	 * @return the value for name
	 *
	 **/
		@Nonnull
	public String getName();

	/**
	 * the city of the user
	 * This field is required.
	 *
	 * @return the value for city
	 *
	 **/
		@Nonnull
	public String getCity();


	/**
	 * @return a clone
	 */
	public IUserIVO_v1 clone();

}
