package de.taimos.dvalin.interconnect.demo.model.requests;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import de.taimos.dvalin.interconnect.demo.model.UserIVO_v1;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonDeserialize(builder = UpdateUserIVO_v1.UpdateUserIVO_v1Builder.class)
public class UpdateUserIVO_v1 extends AbstractIVO implements IUpdateUserIVO_v1 {

private static final long serialVersionUID = 1L;

	/**
	* Builder for the read-only ivo
	*
	*/
	@JsonPOJOBuilder()
	public static class UpdateUserIVO_v1Builder extends AbstractUpdateUserIVO_v1Builder<UpdateUserIVO_v1Builder> implements IVOBuilder {

		// nothing to do here, really

	}

	/**
	* Abstract Builder for the read-only ivo
	*
	* @param <E> type of builder
	*/
	public abstract static class AbstractUpdateUserIVO_v1Builder<E extends AbstractUpdateUserIVO_v1Builder<?>>   {
		private UserIVO_v1 value;
		/**
		 * This field is required.
		 * the object
		 *
		 * @param obj the value to set
		 * @return the builder
		 *
		 **/
		@Nonnull
		@SuppressWarnings("unchecked")
		public E withValue(UserIVO_v1 obj) {
			this.value = obj;
			return (E) this;
		}


		protected void internalFillFromIVO(UpdateUserIVO_v1 ivo) {
			this.withValue(ivo.value);
		}

		/**
		 * @return the entry
		 **/
		public UpdateUserIVO_v1 build() {
			if (this.value == null) {
				throw new IllegalStateException("The attribute value must not be null!");
			}
			UpdateUserIVO_v1 result = new UpdateUserIVO_v1(this);
			return result;
		}
	}

	private final UserIVO_v1 value;

	protected UpdateUserIVO_v1(AbstractUpdateUserIVO_v1Builder<?> builder) {
		this.value = builder.value;
	}

	public UserIVO_v1 getValue() {
		return this.value;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends IVOBuilder> T createBuilder() {
		UpdateUserIVO_v1Builder builder = new UpdateUserIVO_v1Builder();
		builder.internalFillFromIVO(this);
		return (T) builder;
	}

	@Override
	public UpdateUserIVO_v1 clone() {
		return (UpdateUserIVO_v1) super.clone();
	}


	@Override
	public String toString() {
		return this.getClass().getName() + " " + this.value;
	}

	@Override
	public boolean equals(Object obj) {
		if(obj instanceof UpdateUserIVO_v1) {
			return this.value.equals(((UpdateUserIVO_v1)obj).value);
		}
		return false;
	}

}
