/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.demo;

import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.interconnect.core.daemon.Interconnect;
import de.taimos.dvalin.interconnect.demo.api.IUserService;
import de.taimos.dvalin.interconnect.demo.api.UserError;
import de.taimos.dvalin.interconnect.demo.model.UserIVO_v1;
import de.taimos.dvalin.interconnect.demo.model.requests.CreateUserIVO_v1;
import de.taimos.dvalin.interconnect.demo.model.requests.FindUserIVO_v1;
import de.taimos.dvalin.interconnect.model.service.DaemonError;
import java.util.UUID;
import org.springframework.scheduling.annotation.Scheduled;

@ProdComponent
public class Client {
    @Interconnect
    private IUserService svc;

    @Scheduled(initialDelay=1000L, fixedRate=60000L)
    public void init() {
        try {
            System.out.println("Users:");
            for (UserIVO_v1 user : this.svc.findUsers(new FindUserIVO_v1.FindUserIVO_v1Builder().build()).getElements()) {
                System.out.println("  - " + user.getId() + " " + user.getName());
            }
            System.out.println();
            for (int i = 0; i < 5; ++i) {
                String name = UUID.randomUUID().toString();
                UserIVO_v1.UserIVO_v1Builder b = new UserIVO_v1.UserIVO_v1Builder();
                b.withName(name);
                UserIVO_v1 user = b.build();
                System.out.println("Creating user: " + name);
                UserIVO_v1 cUser = this.svc.createUser(((CreateUserIVO_v1.CreateUserIVO_v1Builder)new CreateUserIVO_v1.CreateUserIVO_v1Builder().withValue(user)).build());
                System.out.println("Created user: " + cUser.getName() + " with id " + cUser.getId());
            }
            System.out.println();
            System.out.println("Users:");
            for (UserIVO_v1 user : this.svc.findUsers(new FindUserIVO_v1.FindUserIVO_v1Builder().build()).getElements()) {
                System.out.println("  - " + user.getId() + " " + user.getName());
            }
        }
        catch (DaemonError daemonError) {
            if (daemonError.getNumber().equals((Object)UserError.USER_NOT_FOUND)) {
                System.out.println("User does not exist");
            }
            System.out.println(daemonError.getNumber().toString());
            daemonError.printStackTrace();
        }
    }
}

