package de.taimos.dvalin.interconnect.demo.model.requests;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import de.taimos.dvalin.interconnect.demo.model.UserIVO_v1;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonDeserialize(builder = FindUserByIdIVO_v1.FindUserByIdIVO_v1Builder.class)
public class FindUserByIdIVO_v1 extends AbstractIVO implements IFindUserByIdIVO_v1 {

private static final long serialVersionUID = 1L;

	/**
	* Builder for the read-only ivo
	*
	*/
	@JsonPOJOBuilder()
	public static class FindUserByIdIVO_v1Builder extends AbstractFindUserByIdIVO_v1Builder<FindUserByIdIVO_v1Builder> implements IVOBuilder {

		// nothing to do here, really

	}

	/**
	* Abstract Builder for the read-only ivo
	*
	* @param <E> type of builder
	*/
	public abstract static class AbstractFindUserByIdIVO_v1Builder<E extends AbstractFindUserByIdIVO_v1Builder<?>>   {
		private String id;
		/**
		 * This field is required.
		 * the id
		 *
		 * @param id the value to set
		 * @return the builder
		 *
		 **/
		@Nonnull
		@SuppressWarnings("unchecked")
		public E withId(String id) {
			this.id = id;
			return (E) this;
		}


		protected void internalFillFromIVO(FindUserByIdIVO_v1 ivo) {
			this.withId(ivo.id);
		}

		/**
		 * @return the entry
		 **/
		public FindUserByIdIVO_v1 build() {
			if (this.id == null) {
				throw new IllegalStateException("The attribute id must not be null!");
			}
			FindUserByIdIVO_v1 result = new FindUserByIdIVO_v1(this);
			return result;
		}
	}

	private final  String id;

	protected FindUserByIdIVO_v1(AbstractFindUserByIdIVO_v1Builder<?> builder) {
		this.id = builder.id;
	}

	public String getId() {
		return this.id;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends IVOBuilder> T createBuilder() {
		FindUserByIdIVO_v1Builder builder = new FindUserByIdIVO_v1Builder();
		builder.internalFillFromIVO(this);
		return (T) builder;
	}

	@Override
	public FindUserByIdIVO_v1 clone() {
		return (FindUserByIdIVO_v1) super.clone();
	}


	@Override
	public String toString() {
		return this.getClass().getName() + " " + this.id;
	}

	@Override
	public boolean equals(Object obj) {
		if(obj instanceof FindUserByIdIVO_v1) {
			return this.id.equals(((FindUserByIdIVO_v1)obj).id);
		}
		return false;
	}
}
