package de.taimos.dvalin.interconnect.demo.model;

import de.taimos.dvalin.interconnect.model.ivo.IVO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.taimos.dvalin.interconnect.model.ivo.AbstractIVO;
import de.taimos.dvalin.interconnect.model.ivo.IVOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * test ivo
 *
 * @author thoeger
 */
@SuppressWarnings("all")
@JsonDeserialize(builder = UserIVO_v1.UserIVO_v1Builder.class)
public class UserIVO_v1 extends AbstractIVO implements IUserIVO_v1 {

	private static final long serialVersionUID = 1L;

	/**
	* Builder for the read-only ivo
	*
	*/
	@JsonPOJOBuilder()
	public static class UserIVO_v1Builder extends AbstractUserIVO_v1Builder<UserIVO_v1Builder> implements IVOBuilder {

		// nothing to do here, really

	}


	/**
	* Abstract Builder for the read-only ivo
	*
	* @param <E> type of builder
	*/
	public abstract static class AbstractUserIVO_v1Builder<E extends AbstractUserIVO_v1Builder<?>>   {

		private String name;
		private String id;

		/**
		 * the id
		 *
		 * @param pid the value to set
		 * @return the builder
		 *
		 **/
		@SuppressWarnings("unchecked")
		public E withId(String pid) {
			this.id = pid;
			return (E) this;
		}

		/**
		 * This field is required.
		 * the name of the user
		 *
		 * @param pname the value to set
		 * @return the builder
		 *
		 **/
		@Nonnull
		@SuppressWarnings("unchecked")
		public E withName(String pname) {
			this.name = pname;
			return (E) this;
		}


		protected void internalFillFromIVO(UserIVO_v1 ivo) {
			this.withName(ivo.name);
			this.withId(ivo.id);
		}

		/**
		 * @return the entry
		 **/
		public UserIVO_v1 build() {
			if (this.name == null) {
				throw new IllegalStateException("The attribute name must not be null!");
			}
			UserIVO_v1 result = new UserIVO_v1(this);
			return result;
		}

	}

	private final  String name;
	private final  String id;

	protected UserIVO_v1(AbstractUserIVO_v1Builder<?> builder) {
		this.name = builder.name;
		this.id = builder.id;
	}

	@Override
	public String getId() {
		return this.id;
	}

	@Override
	public long getIdAsLong() {
		try {
			return Long.parseLong(this.id);
		} catch (NumberFormatException e) {
			// string not parsable
			return -1;
		}
	}

	@Override
	public String getName() {
		return this.name;
	}


	@SuppressWarnings("unchecked")
	@Override
	public <T extends IVOBuilder> T createBuilder() {
		UserIVO_v1Builder builder = new UserIVO_v1Builder();
		builder.internalFillFromIVO(this);
		return (T) builder;
	}


	@Override
	public String toString() {
		return this.getClass().getName() + " " + this.id;
	}

	@Override
	public UserIVO_v1 clone() {
		return (UserIVO_v1) super.clone();
	}

	@Override
	public boolean equals(Object obj) {
		if(obj instanceof UserIVO_v1) {
			return this.id.equals(((UserIVO_v1)obj).id);
		}
		return false;
	}

	@Override
	public int hashCode() {
        return this.id.hashCode();
	}

}
