/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.dvalin.interconnect.core.daemon.Interconnect;
import de.taimos.dvalin.interconnect.core.spring.DaemonProxyFactory;
import de.taimos.dvalin.interconnect.model.service.IDaemon;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Component
public class InterconnectBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware,
Serializable {
    private transient ConfigurableListableBeanFactory beanFactory;
    private transient DaemonProxyFactory proxyFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.proxyFactory = (DaemonProxyFactory)beanFactory.getBean(DaemonProxyFactory.class);
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.buildResourceMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    private InjectionMetadata buildResourceMetadata(Class<?> clazz) {
        LinkedList elements = new LinkedList();
        Class<?> targetClass = clazz;
        do {
            LinkedList<InterconnectElement> currElements = new LinkedList<InterconnectElement>();
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Interconnect.class)) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalStateException("@Interconnect annotation is not supported on static fields");
                }
                currElements.add(new InterconnectElement(field, null));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)accessibleObject);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)accessibleObject, (Method)bridgedMethod) || !((Method)accessibleObject).equals(ClassUtils.getMostSpecificMethod((Method)accessibleObject, clazz)) || !bridgedMethod.isAnnotationPresent(Interconnect.class)) continue;
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new IllegalStateException("@Interconnect annotation is not supported on static methods");
                }
                if (((Method)accessibleObject).getParameterTypes().length != 1) {
                    throw new IllegalStateException("@Interconnect annotation requires a single-arg method: " + accessibleObject);
                }
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, clazz);
                currElements.add(new InterconnectElement((Member)((Object)accessibleObject), pd));
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private class InterconnectElement
    extends InjectionMetadata.InjectedElement {
        public InterconnectElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
        }

        private DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new DependencyDescriptor((Field)this.member, true);
            }
            return new DependencyDescriptor(new MethodParameter((Method)this.member, 0), true);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            Class dependencyType = this.getDependencyDescriptor().getDependencyType();
            if (!IDaemon.class.isAssignableFrom(dependencyType)) {
                throw new RuntimeException("Field has to be of type IDaemon but was of type " + dependencyType.getCanonicalName());
            }
            return InterconnectBeanPostProcessor.this.proxyFactory.create(dependencyType);
        }
    }
}

