/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.interconnect.core.InterconnectConnector;
import de.taimos.dvalin.interconnect.core.MessageConnector;
import de.taimos.dvalin.interconnect.core.daemon.DaemonResponse;
import de.taimos.dvalin.interconnect.core.exceptions.InfrastructureException;
import de.taimos.dvalin.interconnect.core.spring.DaemonMessageSenderHeader;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.model.CryptoException;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

@ProdComponent
public final class DaemonMessageSender
implements IDaemonMessageSender {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="jmsTemplate")
    private JmsTemplate template;

    public DaemonMessageSender() {
        this.logger.trace("new bean instance created");
    }

    @PostConstruct
    public void start() throws Exception {
        InterconnectConnector.start();
    }

    @PreDestroy
    public void stop() {
        try {
            InterconnectConnector.stop();
        }
        catch (InfrastructureException e) {
            this.logger.warn("Can not stop MessageConnector", (Throwable)e);
        }
    }

    private void sendIVO(final String correlationID, Destination replyTo, final InterconnectObject ico, final boolean secure) throws Exception {
        final String json = InterconnectMapper.toJson((InterconnectObject)ico);
        this.logger.debug("TextMessage send: " + json);
        this.template.send(replyTo, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage textMessage = session.createTextMessage();
                textMessage.setStringProperty("InterconnectICOClass", ico.getClass().getName());
                textMessage.setJMSCorrelationID(correlationID);
                textMessage.setText(json);
                if (secure) {
                    try {
                        MessageConnector.secureMessage(textMessage);
                    }
                    catch (CryptoException e) {
                        throw new JMSException(e.getMessage());
                    }
                }
                return textMessage;
            }
        });
    }

    @Override
    public void reply(DaemonResponse response) throws Exception {
        this.reply(response, false);
    }

    @Override
    public void reply(String correlationID, Destination replyTo, InterconnectObject ico) throws Exception {
        this.reply(correlationID, replyTo, ico, false);
    }

    @Override
    public void reply(DaemonResponse response, boolean secure) throws Exception {
        this.sendIVO(response.getRequest().getCorrelationID(), response.getRequest().getReplyTo(), response.getResponse(), secure);
    }

    @Override
    public void reply(String correlationID, Destination replyTo, InterconnectObject ico, boolean secure) throws Exception {
        this.sendIVO(correlationID, replyTo, ico, secure);
    }

    @Override
    public void sendToTopic(String topic, InterconnectObject ico, DaemonMessageSenderHeader ... headers) throws Exception {
        this.sendToTopic(topic, ico, false, headers);
    }

    @Override
    public void sendToQueue(String queue, InterconnectObject ico, DaemonMessageSenderHeader ... headers) throws Exception {
        this.sendToQueue(queue, ico, false, headers);
    }

    private static HashMap<String, Object> wrapHeaders(DaemonMessageSenderHeader ... headers) {
        HashMap<String, Object> h = new HashMap<String, Object>(headers.length);
        for (DaemonMessageSenderHeader header : headers) {
            h.put(header.getField().getName(), header.getValue());
        }
        return h;
    }

    @Override
    public void sendToTopic(String topic, InterconnectObject ico, boolean secure, DaemonMessageSenderHeader ... headers) throws Exception {
        InterconnectConnector.sendToTopic(topic, ico, DaemonMessageSender.wrapHeaders(headers), secure);
    }

    @Override
    public void sendToQueue(String queue, InterconnectObject ico, boolean secure, DaemonMessageSenderHeader ... headers) throws Exception {
        InterconnectConnector.sendToQueue(queue, ico, DaemonMessageSender.wrapHeaders(headers), secure);
    }

    @Override
    public void sendToQueue(String queue, InterconnectObject ico, boolean secure, String replyToQueue, String correlationId, DaemonMessageSenderHeader ... headers) throws Exception {
        InterconnectConnector.sendToQueue(queue, ico, DaemonMessageSender.wrapHeaders(headers), secure, replyToQueue, correlationId);
    }
}

