/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.daemon;

import de.taimos.dvalin.interconnect.core.MessageConnector;
import de.taimos.dvalin.interconnect.core.daemon.DaemonRequest;
import de.taimos.dvalin.interconnect.core.daemon.DaemonResponse;
import de.taimos.dvalin.interconnect.core.daemon.IdemponentRetryException;
import de.taimos.dvalin.interconnect.model.InterconnectContext;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.ivo.IPageable;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.daemon.DaemonErrorIVO;
import de.taimos.dvalin.interconnect.model.ivo.daemon.PingIVO;
import de.taimos.dvalin.interconnect.model.ivo.daemon.PongIVO;
import de.taimos.dvalin.interconnect.model.service.DaemonError;
import de.taimos.dvalin.interconnect.model.service.DaemonErrorNumber;
import de.taimos.dvalin.interconnect.model.service.DaemonScanner;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.slf4j.Logger;

public abstract class ADaemonMessageHandler {
    final Map<Class<? extends InterconnectObject>, DaemonScanner.DaemonMethod> registry;
    private final boolean throwExceptionOnTimeout;

    public ADaemonMessageHandler(Class<? extends IDaemonHandler> aHandlerClazz, boolean aThrowExceptionOnTimeout) {
        HashMap<Class, DaemonScanner.DaemonMethod> reg = new HashMap<Class, DaemonScanner.DaemonMethod>();
        for (DaemonScanner.DaemonMethod re : DaemonScanner.scan(aHandlerClazz)) {
            reg.put(re.getRequest(), re);
        }
        this.registry = Collections.unmodifiableMap(reg);
        this.throwExceptionOnTimeout = aThrowExceptionOnTimeout;
    }

    @Deprecated
    public ADaemonMessageHandler(Class<? extends IDaemonHandler> aHandlerClazz, boolean aCatchExceptionsInRequestHandler, boolean aThrowExceptionOnTimeout) {
        this(aHandlerClazz, aThrowExceptionOnTimeout);
    }

    @Deprecated
    public ADaemonMessageHandler(Map<Class<? extends InterconnectObject>, DaemonScanner.DaemonMethod> aRegistry, boolean aCatchExceptionsInRequestHandler, boolean aThrowExceptionOnTimeout) {
        this.registry = Collections.unmodifiableMap(new HashMap<Class<? extends InterconnectObject>, DaemonScanner.DaemonMethod>(aRegistry));
        this.throwExceptionOnTimeout = aThrowExceptionOnTimeout;
    }

    protected abstract void reply(DaemonResponse var1, boolean var2) throws Exception;

    protected abstract IDaemonHandler createRequestHandler();

    protected abstract Logger getLogger();

    public final void onMessage(Message message) throws Exception {
        InterconnectContext.reset();
        long begin = System.currentTimeMillis();
        if (message instanceof TextMessage) {
            int deliveryCount;
            TextMessage textMessage = (TextMessage)message;
            this.getLogger().debug("TextMessage received: {}", (Object)textMessage.getText());
            boolean secure = MessageConnector.isMessageSecure(textMessage);
            if (secure) {
                MessageConnector.decryptMessage(textMessage);
            }
            InterconnectObject ivoIn = InterconnectMapper.fromJson((String)textMessage.getText(), InterconnectObject.class);
            Class<?> icoClass = ivoIn.getClass();
            DaemonRequest request = new DaemonRequest(textMessage.getJMSCorrelationID(), textMessage.getJMSReplyTo(), ivoIn);
            if (icoClass.equals(PingIVO.class)) {
                this.reply(new DaemonResponse(request, (InterconnectObject)new PongIVO.PongIVOBuilder().build()), secure);
                return;
            }
            DaemonScanner.DaemonMethod method = this.registry.get(icoClass);
            if (method == null) {
                throw new Exception("No registered method found for " + icoClass.getSimpleName() + " from " + message.getJMSReplyTo());
            }
            if (method.isSecure() != secure) {
                throw new Exception("Insecure call (is " + secure + " should be " + method.isSecure() + ") for " + icoClass.getSimpleName() + " from " + message.getJMSReplyTo());
            }
            String requestUUID = message.getStringProperty("InterconnectRequestUUID");
            if (requestUUID == null) {
                throw new Exception("No request UUID found in message with " + icoClass.getSimpleName() + " from " + message.getJMSReplyTo());
            }
            try {
                InterconnectContext.setUuid((UUID)UUID.fromString(requestUUID));
            }
            catch (IllegalArgumentException e) {
                throw new Exception("No valid request UUID " + requestUUID + " message with " + icoClass.getSimpleName() + " from " + message.getJMSReplyTo());
            }
            try {
                deliveryCount = message.getIntProperty("JMSXDeliveryCount");
            }
            catch (Exception e) {
                deliveryCount = message.getJMSRedelivered() ? 2 : 1;
                this.getLogger().warn("Can not get JMSXDeliveryCount");
            }
            InterconnectContext.setDeliveryCount((int)deliveryCount);
            InterconnectContext.setRedelivered((boolean)message.getJMSRedelivered());
            Class<?> ivoClass = null;
            if (ivoIn instanceof IVO) {
                ivoClass = ivoIn.getClass();
                InterconnectContext.setRequestClass(ivoClass);
            }
            IDaemonHandler handler = this.createRequestHandler();
            StringBuilder sbInvokeLog = new StringBuilder();
            sbInvokeLog.append("Invoke " + method.getMethod().getName() + "(" + icoClass.getSimpleName() + ")");
            if (ivoIn instanceof IPageable) {
                sbInvokeLog.append(" at Page " + ((IPageable)ivoIn).getOffset() + ";" + ((IPageable)ivoIn).getLimit());
            }
            sbInvokeLog.append(" with " + InterconnectContext.getContext());
            this.getLogger().info(sbInvokeLog.toString());
            if (method.getType() == DaemonScanner.Type.voit) {
                this.handleReceiver(handler, method, ivoIn);
            } else {
                DaemonResponse response;
                try {
                    InterconnectObject out = this.handleRequest(handler, method, ivoIn);
                    response = new DaemonResponse(request, out);
                    long end = System.currentTimeMillis();
                    long runtime = end - begin;
                    if (runtime > method.getTimeoutInMs()) {
                        if (this.throwExceptionOnTimeout) {
                            throw new Exception("Response skipped because runtime " + runtime + " ms was greater than timeout " + method.getTimeoutInMs() + " ms for " + method.getMethod().getName() + "(" + icoClass.getSimpleName() + ")" + " with " + InterconnectContext.getContext());
                        }
                        this.getLogger().warn("Response skipped because runtime " + runtime + " ms was greater than timeout " + method.getTimeoutInMs() + " ms for " + method.getMethod().getName() + "(" + icoClass.getSimpleName() + ")" + " with " + InterconnectContext.getContext());
                        return;
                    }
                    if (runtime > method.getTimeoutInMs() / 2L) {
                        this.getLogger().info("Slow response because runtime " + runtime + " ms for " + method.getMethod().getName() + "(" + icoClass.getSimpleName() + ")" + " with " + InterconnectContext.getContext());
                    }
                }
                catch (DaemonError e) {
                    this.getLogger().debug("DaemonError for " + method.getMethod().getName() + "(" + icoClass.getSimpleName() + ")" + " with " + InterconnectContext.getContext(), (Throwable)e);
                    DaemonErrorIVO.DaemonErrorIVOBuilder error = new DaemonErrorIVO.DaemonErrorIVOBuilder();
                    error.number(e.getNumber().get());
                    error.daemon(e.getNumber().daemon());
                    error.message(e.getMessage());
                    this.reply(new DaemonResponse(request, (InterconnectObject)error.build()), secure);
                    return;
                }
                this.reply(response, secure);
            }
        } else {
            throw new Exception("Invalid message type received: " + message.getClass().getSimpleName());
        }
    }

    private static Throwable extractTargetException(InvocationTargetException e) {
        if (e.getTargetException() != null) {
            return e.getTargetException();
        }
        return e;
    }

    InterconnectObject handleRequest(IDaemonHandler handler, DaemonScanner.DaemonMethod method, InterconnectObject ico) throws DaemonError {
        handler.beforeRequestHook();
        try {
            InterconnectObject interconnectObject = method.invoke(handler, ico);
            return interconnectObject;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof DaemonError) {
                throw (DaemonError)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                handler.exceptionHook((RuntimeException)e.getTargetException());
            }
            Throwable targetException = ADaemonMessageHandler.extractTargetException(e);
            if (method.isIdempotent()) {
                throw new IdemponentRetryException(targetException);
            }
            this.getLogger().error("Exception in non-idempotent " + method.getMethod().getName() + "(" + ico.getClass().getSimpleName() + ")" + " with " + InterconnectContext.getContext(), (Throwable)e);
            throw new DaemonError(new DaemonErrorNumber(){
                private static final long serialVersionUID = 1L;

                public int get() {
                    return -1;
                }

                public String daemon() {
                    return "framework";
                }
            }, targetException);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            handler.afterRequestHook();
        }
    }

    private void handleReceiver(IDaemonHandler handler, DaemonScanner.DaemonMethod method, InterconnectObject ico) {
        handler.beforeRequestHook();
        try {
            method.invoke(handler, ico);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = ADaemonMessageHandler.extractTargetException(e);
            if (method.isIdempotent()) {
                throw new IdemponentRetryException(targetException);
            }
            throw new RuntimeException(targetException);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            handler.afterRequestHook();
        }
    }
}

