/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Preconditions;
import de.taimos.dvalin.interconnect.core.MessageConnector;
import de.taimos.dvalin.interconnect.core.exceptions.InfrastructureException;
import de.taimos.dvalin.interconnect.model.CryptoException;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public final class InterconnectConnector {
    public static final String HEADER_REQUEST_UUID = "InterconnectRequestUUID";
    public static final String HEADER_ICO_CLASS = "InterconnectICOClass";

    private InterconnectConnector() {
    }

    public static void start(String brokerUrl) throws InfrastructureException {
        MessageConnector.start(brokerUrl);
    }

    public static void start() throws InfrastructureException {
        MessageConnector.start();
    }

    public static void stop() throws InfrastructureException {
        MessageConnector.stop();
    }

    public static void sendToDestination(Destination destination, InterconnectObject ico, Map<String, Object> customHeaders, boolean secure, String replyToQueueName, String correlationId) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)destination, (Object)"Destination");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToDestination(destination, body, headers, secure, replyToQueueName, correlationId);
    }

    public static void sendToQueue(String queueName, InterconnectObject ico, Map<String, Object> customHeaders, boolean secure, String replyToQueueName, String correlationId) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToQueue(queueName, body, headers, secure, replyToQueueName, correlationId);
    }

    public static void sendToQueue(String queueName, InterconnectObject ico, Map<String, Object> customHeaders, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToQueue(queueName, body, headers, secure);
    }

    public static void sendToQueue(String queueName, InterconnectObject ico, Map<String, Object> customHeaders, String replyToQueueName, String correlationId) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToQueue(queueName, body, headers, replyToQueueName, correlationId);
    }

    public static void sendToQueue(String queueName, InterconnectObject ico, Map<String, Object> customHeaders) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToQueue(queueName, body, headers);
    }

    public static void sendToQueue(String queueName, InterconnectObject ico) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        InterconnectConnector.sendToQueue(queueName, ico, null);
    }

    public static void sendToTopic(String topicName, InterconnectObject ico, Map<String, Object> customHeaders, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToTopic(topicName, body, headers, secure);
    }

    public static void sendToTopic(String topicName, InterconnectObject ico, Map<String, Object> customHeaders) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)ico);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(1) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_ICO_CLASS, ico.getClass().getName());
        MessageConnector.sendToTopic(topicName, body, headers);
    }

    public static void sendToTopic(String topicName, InterconnectObject ico) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        Preconditions.checkNotNull((Object)ico, (Object)"Interconnect Object");
        InterconnectConnector.sendToTopic(topicName, ico, null);
    }

    public static InterconnectObject receiveFromQueue(String queueName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        TextMessage response = MessageConnector.receiveFromQueue(queueName, selector, timeout, secure);
        try {
            return InterconnectMapper.fromJson((String)response.getText());
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
    }

    public static Response receiveFromQueueEnhanced(String queueName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        TextMessage response = MessageConnector.receiveFromQueue(queueName, selector, timeout, secure);
        try {
            return new Response(InterconnectMapper.fromJson((String)response.getText()), response);
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
    }

    public static List<InterconnectObject> receiveBulkFromQueue(String queueName, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        List<TextMessage> responses = MessageConnector.receiveBulkFromQueue(queueName, selector, maxSize, timeout, secure);
        ArrayList<InterconnectObject> icos = new ArrayList<InterconnectObject>(responses.size());
        try {
            for (TextMessage response : responses) {
                icos.add(InterconnectMapper.fromJson((String)response.getText()));
            }
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
        return icos;
    }

    public static List<Response> receiveBulkFromQueueEnhanced(String queueName, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        List<TextMessage> responses = MessageConnector.receiveBulkFromQueue(queueName, selector, maxSize, timeout, secure);
        ArrayList<Response> enhanceds = new ArrayList<Response>(responses.size());
        try {
            for (TextMessage response : responses) {
                enhanceds.add(new Response(InterconnectMapper.fromJson((String)response.getText()), response));
            }
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
        return enhanceds;
    }

    public static InterconnectObject receiveFromTopic(String topicName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        TextMessage response = MessageConnector.receiveFromTopic(topicName, selector, timeout, secure);
        try {
            return InterconnectMapper.fromJson((String)response.getText());
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
    }

    public static Response receiveFromTopicEnhanced(String topicName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        TextMessage response = MessageConnector.receiveFromTopic(topicName, selector, timeout, secure);
        try {
            return new Response(InterconnectMapper.fromJson((String)response.getText()), response);
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
    }

    public static List<InterconnectObject> receiveBulkFromTopic(String topicName, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        List<TextMessage> responses = MessageConnector.receiveBulkFromTopic(topicName, selector, maxSize, timeout, secure);
        ArrayList<InterconnectObject> icos = new ArrayList<InterconnectObject>(responses.size());
        try {
            for (TextMessage response : responses) {
                icos.add(InterconnectMapper.fromJson((String)response.getText()));
            }
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
        return icos;
    }

    public static List<Response> receiveBulkFromTopicEnhanced(String topicName, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)topicName, (Object)"Topic name");
        List<TextMessage> responses = MessageConnector.receiveBulkFromTopic(topicName, selector, maxSize, timeout, secure);
        ArrayList<Response> enhanceds = new ArrayList<Response>(responses.size());
        try {
            for (TextMessage response : responses) {
                enhanceds.add(new Response(InterconnectMapper.fromJson((String)response.getText()), response));
            }
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
        return enhanceds;
    }

    public static InterconnectObject request(UUID uuid, String queueName, InterconnectObject requestICO, Map<String, Object> customHeaders, boolean secure, long receiveTimeout, long sendTimeout, int priority) throws InfrastructureException, CryptoException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)uuid, (Object)"Universally unique identifier of the request");
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)requestICO, (Object)"Request Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)requestICO);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(2) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_REQUEST_UUID, uuid.toString());
        headers.put(HEADER_ICO_CLASS, requestICO.getClass().getName());
        TextMessage response = MessageConnector.request(queueName, body, headers, secure, receiveTimeout, sendTimeout, priority);
        try {
            return InterconnectMapper.fromJson((String)response.getText());
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
    }

    public static InterconnectObject request(UUID uuid, String queueName, InterconnectObject requestICO, Map<String, Object> customHeaders) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)uuid, (Object)"Universally unique identifier of the request");
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)requestICO, (Object)"Request Interconnect Object");
        String body = InterconnectMapper.toJson((InterconnectObject)requestICO);
        HashMap<Object, Object> headers = customHeaders == null ? new HashMap(2) : new HashMap<String, Object>(customHeaders);
        headers.put(HEADER_REQUEST_UUID, uuid.toString());
        headers.put(HEADER_ICO_CLASS, requestICO.getClass().getName());
        TextMessage response = MessageConnector.request(queueName, body, headers);
        try {
            return InterconnectMapper.fromJson((String)response.getText());
        }
        catch (JMSException e) {
            throw new InfrastructureException("Failed to read message");
        }
    }

    public static InterconnectObject request(UUID uuid, String queueName, InterconnectObject requestICO) throws InfrastructureException, JsonGenerationException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)uuid, (Object)"Universally unique identifier of the request");
        Preconditions.checkNotNull((Object)queueName, (Object)"Queue name");
        Preconditions.checkNotNull((Object)requestICO, (Object)"Request Interconnect Object");
        return InterconnectConnector.request(uuid, queueName, requestICO, null);
    }

    public static final class Response {
        private final InterconnectObject ico;
        private final TextMessage jmsTextMessage;

        public Response(InterconnectObject ico, TextMessage jmsTextMessage) {
            this.ico = ico;
            this.jmsTextMessage = jmsTextMessage;
        }

        public InterconnectObject getICO() {
            return this.ico;
        }

        public TextMessage getJMSTextMessage() {
            return this.jmsTextMessage;
        }
    }
}

