/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IVORefreshSender {
    private static IVORefreshSender instance;
    private volatile PooledConnectionFactory pooledConnectionFactory;
    public static final String TCC_UPDATE_TOPIC = "TCCUpdateTopic";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static IVORefreshSender getInstance() {
        if (instance == null) {
            instance = new IVORefreshSender();
        }
        return instance;
    }

    private IVORefreshSender() {
        try {
            ActiveMQConnectionFactory mqFactory;
            String mqUrl = System.getProperty("interconnect.jms.broker");
            if (mqUrl == null) {
                this.logger.warn("No interconnect.jms.broker configuredd, using tcp://localhost:61616.");
                mqFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
            } else {
                mqFactory = new ActiveMQConnectionFactory(mqUrl);
            }
            this.pooledConnectionFactory = new PooledConnectionFactory(mqFactory);
            this.pooledConnectionFactory.setCreateConnectionOnStartup(true);
            this.pooledConnectionFactory.setIdleTimeout(0);
            this.pooledConnectionFactory.setMaxConnections(3);
            this.pooledConnectionFactory.setMaximumActiveSessionPerConnection(100);
            this.pooledConnectionFactory.setTimeBetweenExpirationCheckMillis(30000L);
            this.pooledConnectionFactory.setBlockIfSessionPoolIsFull(false);
            this.pooledConnectionFactory.start();
        }
        catch (Exception e) {
            this.logger.error("Failed to setup the message queues", (Throwable)e);
        }
    }

    public void mqTeardown() {
        this.pooledConnectionFactory.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Serializable object) {
        Connection connection = null;
        try {
            connection = this.pooledConnectionFactory.createConnection();
            Session updateSession = null;
            try {
                updateSession = connection.createSession(false, 1);
                Topic updateTopic = updateSession.createTopic(TCC_UPDATE_TOPIC);
                MessageProducer utopicmp = null;
                try {
                    utopicmp = updateSession.createProducer((Destination)updateTopic);
                    utopicmp.setDeliveryMode(1);
                    utopicmp.send((Message)updateSession.createObjectMessage(object));
                }
                finally {
                    if (utopicmp != null) {
                        try {
                            utopicmp.close();
                        }
                        catch (JMSException e) {
                            this.logger.warn("Can not close producer", (Throwable)e);
                        }
                    }
                }
            }
            finally {
                if (updateSession != null) {
                    try {
                        updateSession.close();
                    }
                    catch (JMSException e) {
                        this.logger.warn("Can not close session", (Throwable)e);
                    }
                }
            }
        }
        catch (JMSException e) {
            this.logger.error("Can not send message", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    this.logger.warn("Can not close connection", (Throwable)e);
                }
            }
        }
    }
}

