/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.dvalin.interconnect.core.daemon.ADaemonMessageHandler;
import de.taimos.dvalin.interconnect.core.daemon.DaemonMethodRegistry;
import de.taimos.dvalin.interconnect.core.daemon.DaemonResponse;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;

public class MultiDaemonMessageHandler
extends ADaemonMessageHandler {
    private final Logger logger;
    private final IDaemonMessageSender messageSender;
    private final BeanFactory beanFactory;

    public MultiDaemonMessageHandler(Logger aLogger, Collection<Class<? extends IDaemonHandler>> aHandlerClazzes, IDaemonMessageSender aMessageSender, BeanFactory beanFactory) {
        super(aHandlerClazzes, false);
        this.logger = aLogger;
        this.messageSender = aMessageSender;
        this.beanFactory = beanFactory;
    }

    @Override
    protected void reply(DaemonResponse response, boolean secure) throws Exception {
        this.messageSender.reply(response, secure);
    }

    @Override
    protected IDaemonHandler createRequestHandler(DaemonMethodRegistry.RegistryEntry registryEntry) {
        return (IDaemonHandler)this.beanFactory.getBean(registryEntry.getHandlerClazz());
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }
}

